/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.range.impl;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.sensors.fov.ApogyAddonsSensorsFOVFactory;
import org.eclipse.apogy.addons.sensors.fov.DistanceRange;
import org.eclipse.apogy.addons.sensors.fov.RectangularFrustrumFieldOfView;
import org.eclipse.apogy.addons.sensors.fov.RectangularFrustrumFieldOfViewSamplingShape;
import org.eclipse.apogy.addons.sensors.range.ApogyAddonsSensorsRangeFacade;
import org.eclipse.apogy.addons.sensors.range.ApogyAddonsSensorsRangeFactory;
import org.eclipse.apogy.addons.sensors.range.RasterScanSettings;
import org.eclipse.apogy.addons.sensors.range.RayData;
import org.eclipse.apogy.addons.sensors.range.impl.SimpleRasterScanRangeScannerSimulatorImpl;
import org.eclipse.apogy.common.geometry.data.Mesh;
import org.eclipse.apogy.common.geometry.data25d.ApogyCommonGeometryData25DFacade;
import org.eclipse.apogy.common.geometry.data25d.Coordinates25D;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMeshPolygonSampler;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRasterScanRangeScannerSimulatorCustomImpl
extends SimpleRasterScanRangeScannerSimulatorImpl {
    private static final Logger Logger = LoggerFactory.getLogger(SimpleRasterScanRangeScannerSimulatorImpl.class);

    @Override
    public synchronized RasterScanSettings getScanSettings() {
        RasterScanSettings rasterScanSettings = (RasterScanSettings)this.getInput();
        if (rasterScanSettings == null) {
            EList children = this.getChildren();
            for (Node node : children) {
                if (node instanceof RasterScanSettings) {
                    rasterScanSettings = (RasterScanSettings)node;
                    continue;
                }
                if (!(node instanceof GroupNode)) continue;
                GroupNode groupNode = (GroupNode)node;
                EList groupChildren = groupNode.getChildren();
                for (Node n : groupChildren) {
                    if (!(n instanceof RasterScanSettings)) continue;
                    rasterScanSettings = (RasterScanSettings)n;
                }
            }
            if (rasterScanSettings == null) {
                TransformNode transformNode = ApogyCommonTopologyFacade.INSTANCE.createTransformNodeXYZ(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                transformNode.setDescription("Field Of View Transform");
                this.getChildren().add((Object)transformNode);
                rasterScanSettings = ApogyAddonsSensorsRangeFacade.INSTANCE.createRasterScanSettings(0.0, 100.0, Math.toRadians(90.0), Math.toRadians(45.0), 100, 100);
                transformNode.getChildren().add((Object)rasterScanSettings);
            }
        }
        return rasterScanSettings;
    }

    @Override
    public void setInput(RasterScanSettings newInput) {
        RasterScanSettings currentScanSettings = this.getScanSettings();
        currentScanSettings.setDescription(newInput.getDescription());
        currentScanSettings.setHorizontalFieldOfViewAngle(newInput.getHorizontalFieldOfViewAngle());
        currentScanSettings.setHorizontalResolution(newInput.getHorizontalResolution());
        currentScanSettings.setRange((DistanceRange)EcoreUtil.copy((EObject)newInput.getRange()));
        currentScanSettings.setVerticalFieldOfViewAngle(newInput.getVerticalFieldOfViewAngle());
        currentScanSettings.setVerticalResolution(newInput.getVerticalResolution());
        super.setInput(newInput);
    }

    @Override
    public CartesianTriangularMesh getCroppedMesh() {
        CartesianTriangularMesh croppedMesh = null;
        Matrix4d laserToMesh = ApogyCommonTopologyFacade.INSTANCE.expressInFrame((Node)this, this.getMeshNode());
        CartesianTriangularMeshPolygonSampler meshSampler = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianTriangularMeshPolygonSampler();
        RectangularFrustrumFieldOfViewSamplingShape samplingShape = ApogyAddonsSensorsFOVFactory.eINSTANCE.createRectangularFrustrumFieldOfViewSamplingShape();
        samplingShape.setRectangularFrustrumFieldOfView((RectangularFrustrumFieldOfView)this.getScanSettings());
        samplingShape.setTransform(ApogyCommonMathFacade.INSTANCE.createMatrix4x4(laserToMesh));
        meshSampler.getPolygonSamplingShapes().add((Object)samplingShape);
        try {
            croppedMesh = (CartesianTriangularMesh)meshSampler.process((Object)((Mesh)this.meshNode.getContent()));
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        return croppedMesh;
    }

    @Override
    public List<RayData> getSimulatedRays() {
        ArrayList<RayData> rays = new ArrayList<RayData>();
        double startAzimuth = -(this.getScanSettings().getHorizontalFieldOfViewAngle() / 2.0);
        double startElevation = -(this.getScanSettings().getVerticalFieldOfViewAngle() / 2.0);
        double azimuth = startAzimuth;
        double azimuthIncrement = this.getScanSettings().getHorizontalFieldOfViewAngle() / (double)(this.getScanSettings().getHorizontalResolution() - 1);
        double elevation = startElevation;
        double elevetationIncrement = this.getScanSettings().getVerticalFieldOfViewAngle() / (double)(this.getScanSettings().getVerticalResolution() - 1);
        int horizontalResolution = this.getScanSettings().getHorizontalResolution();
        int verticalResolution = this.getScanSettings().getVerticalResolution();
        int azimuthIndex = 0;
        while (azimuthIndex < horizontalResolution) {
            elevation = startElevation;
            int elevationIndex = 0;
            while (elevationIndex < verticalResolution) {
                RayData rayData = ApogyAddonsSensorsRangeFactory.eINSTANCE.createRayData();
                rayData.setOrigin(new Point3d());
                Vector3d v = new Vector3d(-Math.sin(elevation), Math.cos(elevation) * Math.sin(azimuth), Math.cos(elevation) * Math.cos(azimuth));
                v.normalize();
                rayData.setDirection(v);
                rays.add(rayData);
                elevation += elevetationIncrement;
                ++elevationIndex;
            }
            azimuth += azimuthIncrement;
            ++azimuthIndex;
        }
        return rays;
    }

    @Override
    public double applyRangeNoise(double range, RayData cleanRayData, RayData noisyRayData) {
        if (this.isNoiseEnabled()) {
            double noisyRange = range + (-0.5 + Math.random()) * this.getRangeNoiseAmplitude();
            return noisyRange;
        }
        return range;
    }

    @Override
    public Coordinates25D createCoordinates25D(RayData rayData, double range) {
        if (range != Double.NaN && this.getScanSettings().getRange().isWithinRange(range)) {
            Vector3d v = rayData.getDirection();
            v.normalize();
            v.scale(range);
            v.add((Tuple3d)rayData.getOrigin());
            return ApogyCommonGeometryData25DFacade.INSTANCE.createCoordinates25D(v.x, v.y, v.z);
        }
        return null;
    }

    @Override
    public RayData applyOrientationNoise(RayData rayData) {
        RayData noisyOrientation = (RayData)EcoreUtil.copy((EObject)rayData);
        return noisyOrientation;
    }
}

