/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.ui.jme3;

import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.util.ArrayList;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;

public class EnvironmentUIJME3Utilities {
    public static Mesh createGrid(float gridSize, float planeSize) {
        Vector3f p2;
        Vector3f p1;
        Vector3f p22;
        Vector3f p12;
        float planeHalfSize = planeSize / 2.0f;
        ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        float x = 0.0f;
        while (x <= planeHalfSize) {
            p12 = new Vector3f(x, -planeHalfSize, 0.0f);
            p22 = new Vector3f(x, planeHalfSize, 0.0f);
            verticesList.add(p12);
            verticesList.add(p22);
            indexesList.add(verticesList.indexOf(p12));
            indexesList.add(verticesList.indexOf(p22));
            x += gridSize;
        }
        x = 0.0f;
        while (x >= -planeHalfSize) {
            p12 = new Vector3f(x, -planeHalfSize, 0.0f);
            p22 = new Vector3f(x, planeHalfSize, 0.0f);
            verticesList.add(p12);
            verticesList.add(p22);
            indexesList.add(verticesList.indexOf(p12));
            indexesList.add(verticesList.indexOf(p22));
            x -= gridSize;
        }
        float y = 0.0f;
        while (y <= planeHalfSize) {
            p1 = new Vector3f(-planeHalfSize, y, 0.0f);
            p2 = new Vector3f(planeHalfSize, y, 0.0f);
            verticesList.add(p1);
            verticesList.add(p2);
            indexesList.add(verticesList.indexOf(p1));
            indexesList.add(verticesList.indexOf(p2));
            y += gridSize;
        }
        y = 0.0f;
        while (y >= -planeHalfSize) {
            p1 = new Vector3f(-planeHalfSize, y, 0.0f);
            p2 = new Vector3f(planeHalfSize, y, 0.0f);
            verticesList.add(p1);
            verticesList.add(p2);
            indexesList.add(verticesList.indexOf(p1));
            indexesList.add(verticesList.indexOf(p2));
            y -= gridSize;
        }
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
        mesh.setBuffer(VertexBuffer.Type.Index, 2, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
        mesh.updateBound();
        mesh.updateCounts();
        return mesh;
    }

    public static Mesh createPlane(float planeSize) {
        float planeHalfSize = planeSize / 2.0f;
        ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        Vector3f p0 = new Vector3f(-planeHalfSize, -planeHalfSize, 0.0f);
        Vector3f p1 = new Vector3f(planeHalfSize, -planeHalfSize, 0.0f);
        Vector3f p2 = new Vector3f(planeHalfSize, planeHalfSize, 0.0f);
        Vector3f p3 = new Vector3f(-planeHalfSize, planeHalfSize, 0.0f);
        verticesList.add(p0);
        verticesList.add(p1);
        verticesList.add(p2);
        verticesList.add(p3);
        indexesList.add(new Integer(0));
        indexesList.add(new Integer(1));
        indexesList.add(new Integer(2));
        indexesList.add(new Integer(0));
        indexesList.add(new Integer(2));
        indexesList.add(new Integer(3));
        Mesh mesh = new Mesh();
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
        mesh.setBuffer(VertexBuffer.Type.Index, 2, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
        mesh.updateBound();
        mesh.updateCounts();
        return mesh;
    }
}

