/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.moon.provider;

import java.text.DecimalFormat;
import org.eclipse.apogy.core.environment.moon.SelenographicCoordinates;
import org.eclipse.apogy.core.environment.moon.provider.SelenographicCoordinatesItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;

public class SelenographicCoordinatesCustomItemProvider
extends SelenographicCoordinatesItemProvider {
    public static final String DEGREE_STRING = "\u00b0";
    private final DecimalFormat decimalFormat = new DecimalFormat("0.0###########");
    private final DecimalFormat altitudeDecimalFormat = new DecimalFormat("0.0");

    public SelenographicCoordinatesCustomItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public String getText(Object object) {
        SelenographicCoordinates selenographicCoordinates = (SelenographicCoordinates)object;
        String string = this.getString("_UI_SelenographicCoordinates_type");
        string = String.valueOf(string) + this.getSuffix(selenographicCoordinates);
        return string;
    }

    protected String getSuffix(SelenographicCoordinates selenographicCoordinates) {
        String string = " (" + this.decimalFormat.format(Math.toDegrees(selenographicCoordinates.getLatitude())) + DEGREE_STRING;
        string = String.valueOf(string) + ", ";
        string = String.valueOf(string) + this.decimalFormat.format(Math.toDegrees(selenographicCoordinates.getLongitude())) + DEGREE_STRING;
        string = String.valueOf(string) + ", ";
        string = String.valueOf(string) + this.altitudeDecimalFormat.format(selenographicCoordinates.getElevation()) + "m)";
        return string;
    }
}

