/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.composites;

import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class DateAndTimeComposite
extends Composite {
    protected DateTime dateWidget;
    protected DateTime timeWidget;
    protected Spinner millisecondsSpinner;
    protected Date selectedDate = new Date();

    public DateAndTimeComposite(Composite parent, int style) {
        this(parent, style, new Date());
    }

    public DateAndTimeComposite(Composite parent, int style, Date date) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        Composite top = new Composite((Composite)this, 0);
        top.setLayout((Layout)new GridLayout(1, true));
        top.setLayoutData((Object)new GridData(4, 128, false, false));
        this.dateWidget = new DateTime(top, 1024);
        this.dateWidget.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DateAndTimeComposite.this.selectedDate = DateAndTimeComposite.this.updateSelectedDate();
                DateAndTimeComposite.this.newDateSelected(DateAndTimeComposite.this.selectedDate);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        GridData gd_dateWidget = new GridData(0x1000000, 128, false, false, 2, 1);
        this.dateWidget.setLayoutData((Object)gd_dateWidget);
        Composite timeOfDayComposite = new Composite(top, 0);
        timeOfDayComposite.setLayout((Layout)new GridLayout(2, false));
        timeOfDayComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label timeLable = new Label(timeOfDayComposite, 0);
        timeLable.setText("Time Of Day:");
        timeLable.setAlignment(131072);
        timeLable.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.timeWidget = new DateTime(timeOfDayComposite, 0x10000880);
        this.timeWidget.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent arg0) {
                DateAndTimeComposite.this.selectedDate = DateAndTimeComposite.this.updateSelectedDate();
                DateAndTimeComposite.this.newDateSelected(DateAndTimeComposite.this.selectedDate);
            }

            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.timeWidget.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
                DateAndTimeComposite.this.selectedDate = DateAndTimeComposite.this.updateSelectedDate();
                DateAndTimeComposite.this.newDateSelected(DateAndTimeComposite.this.selectedDate);
            }

            public void keyPressed(KeyEvent arg0) {
                DateAndTimeComposite.this.selectedDate = DateAndTimeComposite.this.updateSelectedDate();
                DateAndTimeComposite.this.newDateSelected(DateAndTimeComposite.this.selectedDate);
            }
        });
        this.timeWidget.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        Composite millisecondsComposite = new Composite(top, 0);
        millisecondsComposite.setLayout((Layout)new GridLayout(2, false));
        millisecondsComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label millisecondsLabel = new Label(millisecondsComposite, 0);
        millisecondsLabel.setText("Miliseconds :");
        millisecondsLabel.setAlignment(131072);
        millisecondsLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.millisecondsSpinner = new Spinner(millisecondsComposite, 2048);
        this.millisecondsSpinner.setToolTipText("Milliseconds");
        this.millisecondsSpinner.setMinimum(0);
        this.millisecondsSpinner.setMaximum(999);
        this.millisecondsSpinner.setIncrement(1);
        this.millisecondsSpinner.setSelection(0);
        this.millisecondsSpinner.pack();
        this.millisecondsSpinner.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.millisecondsSpinner.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DateAndTimeComposite.this.selectedDate = DateAndTimeComposite.this.updateSelectedDate();
                DateAndTimeComposite.this.newDateSelected(DateAndTimeComposite.this.selectedDate);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.setSelectedDate(date);
    }

    public Date getSelectedDate() {
        return this.selectedDate;
    }

    public void setSelectedDate(Date date) {
        if (date != null) {
            this.selectedDate = date;
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            if (this.dateWidget != null) {
                this.dateWidget.setDate(calendar.get(1), calendar.get(2), calendar.get(5));
                this.dateWidget.redraw();
            }
            if (this.timeWidget != null) {
                this.timeWidget.setHours(calendar.get(11));
                this.timeWidget.setMinutes(calendar.get(12));
                this.timeWidget.setSeconds(calendar.get(13));
            }
            if (this.millisecondsSpinner != null) {
                this.millisecondsSpinner.setSelection(calendar.get(14));
            }
        }
    }

    protected void newDateSelected(Date date) {
    }

    private Date updateSelectedDate() {
        Date date = null;
        if (this.dateWidget != null && this.timeWidget != null) {
            int year = this.dateWidget.getYear();
            int month = this.dateWidget.getMonth();
            int day = this.dateWidget.getDay();
            int hrs = this.timeWidget.getHours();
            int min = this.timeWidget.getMinutes();
            int sec = this.timeWidget.getSeconds();
            int milliseconds = this.millisecondsSpinner.getSelection();
            GregorianCalendar calendar = new GregorianCalendar(year, month, day, hrs, min, sec);
            date = new Date(calendar.getTime().getTime() + (long)milliseconds);
        }
        return date;
    }
}

