/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.renderers;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javax.inject.Inject;
import org.eclipse.apogy.common.emf.ui.composites.AbstractEObjectComposite;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VAttachment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.emfforms.spi.view.annotation.model.VAnnotation;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyCompositeRenderer
extends SimpleControlSWTRenderer {
    public static final String BUNDLE_NAME_ID = "bundleName";
    public static final String CLASS_NAME_ID = "className";
    private static final Logger Logger = LoggerFactory.getLogger(ApogyCompositeRenderer.class);
    private Control control;
    private InstanciationError error = InstanciationError.NONE;
    private AbstractEObjectComposite userComposite;

    @Inject
    public ApogyCompositeRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        SWTGridDescription rendererGridDescription = GridDescriptionFactory.INSTANCE.createEmptyGridDescription();
        rendererGridDescription.setRows(1);
        rendererGridDescription.setColumns(1);
        ArrayList<SWTGridCell> grid = new ArrayList<SWTGridCell>();
        SWTGridCell controlCel = this.createControlCell(grid.size());
        grid.add(controlCel);
        rendererGridDescription.setGrid(grid);
        return rendererGridDescription;
    }

    public Control render(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        try {
            return this.createSWTControl(parent);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected final Control createControl(Composite parent) throws DatabindingFailedException {
        this.control = this.createSWTControl(parent);
        if (this.control == null) {
            return null;
        }
        return this.control;
    }

    protected Control createSWTControl(Composite parent) throws DatabindingFailedException {
        try {
            this.userComposite = this.instanciateUserComposite(parent, 0, this.getBundleName(this.getVElement()), this.getClassName(this.getVElement()));
            this.userComposite.setRootEObject(this.getViewModelContext().getDomainModel());
        }
        catch (Exception e) {
            parent.setBackground(new Color((Device)parent.getDisplay(), 255, 255, 0));
            this.createErrorComposite(parent, 0, e.toString());
            Logger.error("Failed to instanciate user composite!", (Throwable)e);
        }
        return parent;
    }

    protected String getBundleName(VElement vElement) {
        EList attachments = vElement.getAttachments();
        for (VAttachment vAttachment : attachments) {
            VAnnotation vAnnotation;
            if (!(vAttachment instanceof VAnnotation) || (vAnnotation = (VAnnotation)vAttachment).getKey().compareToIgnoreCase(BUNDLE_NAME_ID) != 0) continue;
            return vAnnotation.getValue();
        }
        return "<null>";
    }

    protected String getClassName(VElement vElement) {
        EList attachments = vElement.getAttachments();
        for (VAttachment vAttachment : attachments) {
            VAnnotation vAnnotation;
            if (!(vAttachment instanceof VAnnotation) || (vAnnotation = (VAnnotation)vAttachment).getKey().compareToIgnoreCase(CLASS_NAME_ID) != 0) continue;
            return vAnnotation.getValue();
        }
        return "<null>";
    }

    protected AbstractEObjectComposite instanciateUserComposite(Composite parent, int style, String bundleName, String className) throws Exception {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            this.error = InstanciationError.BUNDLE_NOT_FOUND;
            throw new Exception("Bundle < " + bundleName + "> not found!");
        }
        Class compositeClass = null;
        try {
            compositeClass = bundle.loadClass(className);
        }
        catch (Exception e) {
            this.error = InstanciationError.CLASS_NOT_FOUND;
            throw e;
        }
        if (AbstractEObjectComposite.class.isAssignableFrom(compositeClass)) {
            Constructor constructor = compositeClass.getConstructor(Composite.class, Integer.TYPE);
            Object object = constructor.newInstance(parent, style);
            return (AbstractEObjectComposite)object;
        }
        this.error = InstanciationError.UNSUPPORTED_CLASS_TYPE;
        throw new Exception("Specified class  is not supported!");
    }

    protected String getUnsetText() {
        return "unset";
    }

    protected Composite createErrorComposite(Composite parent, int style, String message) {
        Composite composite = new Composite(parent, style);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label bundleNameLabel = new Label(composite, 0);
        bundleNameLabel.setText("Specified Bundle Name : ");
        Label bundleName = new Label(composite, 0);
        bundleName.setText(this.getBundleName(this.getVElement()));
        if (this.error == InstanciationError.BUNDLE_NOT_FOUND) {
            bundleName.setBackground(new Color((Device)composite.getDisplay(), 255, 0, 0));
        } else {
            bundleName.setBackground(new Color((Device)composite.getDisplay(), 255, 255, 255));
        }
        Label classNameLabel = new Label(composite, 0);
        classNameLabel.setText("Specified Class Name : ");
        Label className = new Label(composite, 0);
        className.setText(this.getClassName(this.getVElement()));
        if (this.error == InstanciationError.CLASS_NOT_FOUND || this.error == InstanciationError.UNSUPPORTED_CLASS_TYPE) {
            className.setBackground(new Color((Device)composite.getDisplay(), 255, 0, 0));
        } else {
            className.setBackground(new Color((Device)composite.getDisplay(), 255, 255, 255));
        }
        Label messageLabel = new Label(composite, 0);
        messageLabel.setText("Error : ");
        Label errorMessage = new Label(composite, 0);
        errorMessage.setText(message);
        errorMessage.setBackground(new Color((Device)composite.getDisplay(), 255, 0, 0));
        return composite;
    }

    private static enum InstanciationError {
        NONE,
        BUNDLE_NOT_FOUND,
        CLASS_NOT_FOUND,
        UNSUPPORTED_CLASS_TYPE;

    }
}

