/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.services;

import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.swt.core.di.EMFFormsDIRendererService;

public abstract class AbstractClassBasedRendererService
implements EMFFormsDIRendererService<VControl> {
    public static double DEFAULT_APPLICABLE_VALUE = 10.0;
    protected EMFFormsDatabinding databindingService;
    protected ReportService reportService;

    protected void setEMFFormsDatabinding(EMFFormsDatabinding databindingService) {
        this.databindingService = databindingService;
    }

    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public double isApplicable(VElement vElement, ViewModelContext viewModelContext) {
        IValueProperty valueProperty;
        if (!VControl.class.isInstance(vElement)) {
            return Double.NaN;
        }
        VControl control = (VControl)vElement;
        try {
            valueProperty = this.databindingService.getValueProperty(control.getDomainModelReference(), viewModelContext.getDomainModel());
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return Double.NaN;
        }
        EStructuralFeature eStructuralFeature = (EStructuralFeature)EStructuralFeature.class.cast(valueProperty.getValueType());
        if (this.getApplicableClass().isAssignableFrom(eStructuralFeature.getEType().getInstanceClass())) {
            if (eStructuralFeature.isMany()) {
                if (this.isManyValuesSupported()) {
                    return DEFAULT_APPLICABLE_VALUE;
                }
            } else {
                return DEFAULT_APPLICABLE_VALUE;
            }
        }
        return Double.NaN;
    }

    protected abstract Class<?> getApplicableClass();

    protected abstract boolean isManyValuesSupported();
}

