/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.wizards;

import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.Constants;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.ui.ApogyCommonUiFacade;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;

public abstract class AbstractWizard<RootEObject extends EObject, ResolvedEObject extends EObject, ItemObject>
extends Wizard {
    private RootEObject rootEObject;
    private FeaturePath featurePath;
    private EClassSettings eClassSettings;
    private ResolvedEObject resolvedEObject;

    public AbstractWizard(RootEObject rootEObject) {
        this(rootEObject, null, null, null);
    }

    public AbstractWizard(RootEObject rootEObject, EClassSettings settings) {
        this(rootEObject, null, null, settings);
    }

    public AbstractWizard(RootEObject rootEObject, FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        this(rootEObject, featurePath, eStructuralFeature, null);
    }

    public AbstractWizard(RootEObject rootEObject, FeaturePath featurePath, EStructuralFeature eStructuralFeature, EClassSettings settings) {
        this.rootEObject = rootEObject;
        if (rootEObject == null) {
            throw new NullPointerException(String.valueOf(((Object)((Object)this)).getClass().getName()) + "(" + rootEObject + ", " + featurePath + ", " + settings + "): RootObject argument is null.");
        }
        this.featurePath = featurePath;
        this.resolvedEObject = ApogyCommonEMFFacade.INSTANCE.resolveOwner(rootEObject, featurePath);
        String exceptionMessage = String.valueOf(((Object)((Object)this)).getClass().getName()) + "(" + rootEObject + ", " + featurePath + ", " + settings + "): Resolved Object is not consistent.";
        if (this.resolvedEObject == null) {
            throw new IllegalArgumentException(exceptionMessage);
        }
        this.eClassSettings = settings;
        this.configureWizard();
    }

    protected void configureWizard() {
        this.setWindowTitle("Apogy Wizard");
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
        this.setDefaultPageImageDescriptor(Constants.APOGY_WIZARD_IMAGE_DESCRIPTOR);
    }

    public final RootEObject getRootEObject() {
        return this.rootEObject;
    }

    public final FeaturePath getFeaturePath() {
        return this.featurePath;
    }

    public final EClassSettings getEClassSettings() {
        return this.eClassSettings;
    }

    public final ResolvedEObject getResolvedEObject() {
        return this.resolvedEObject;
    }

    public void addPage(IWizardPage page) {
        super.addPage(page);
        ApogyCommonUiFacade.INSTANCE.adjustWizardPage((WizardPage)page, Double.valueOf(0.8));
    }
}

