/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.ui.composites;

import com.ibm.icu.text.DecimalFormat;
import javax.vecmath.Point3d;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.math.ui.composites.Tuple3dComposite;
import org.eclipse.apogy.core.ApogySystemApiAdapter;
import org.eclipse.apogy.core.PoseProvider;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DeltaPoseComposite
extends Composite {
    private Adapter poseAdapter;
    private ApogySystemApiAdapter variable1ApogySystemApiAdapter;
    private ApogySystemApiAdapter variable2ApogySystemApiAdapter;
    private final Text textDistance;
    private final Tuple3dComposite deltaDistanceComposite;
    private final Tuple3dComposite deltaOrientationComposite;
    private final DecimalFormat distanceFormat = new DecimalFormat("0.000");

    public DeltaPoseComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        Label lblDistancem = new Label((Composite)this, 0);
        lblDistancem.setAlignment(131072);
        lblDistancem.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblDistancem.setText("Distance (m):");
        this.textDistance = new Text((Composite)this, 2048);
        this.textDistance.setToolTipText("Distance between the variables, in meters.");
        this.textDistance.setEditable(false);
        this.textDistance.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblPositionDistancem = new Label((Composite)this, 0);
        lblPositionDistancem.setAlignment(131072);
        lblPositionDistancem.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPositionDistancem.setText("Position Delta (m):");
        this.deltaDistanceComposite = new Tuple3dComposite((Composite)this, 0);
        this.deltaDistanceComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.deltaDistanceComposite.setEnableEditing(false);
        Label lblOrientationDeltadeg = new Label((Composite)this, 0);
        lblOrientationDeltadeg.setAlignment(131072);
        lblOrientationDeltadeg.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblOrientationDeltadeg.setText("Orientation Delta (deg):");
        this.deltaOrientationComposite = new Tuple3dComposite((Composite)this, 0, "0.000");
        this.deltaOrientationComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.deltaOrientationComposite.setEnableEditing(false);
        this.setDisplaysEnabled(false);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (DeltaPoseComposite.this.variable1ApogySystemApiAdapter != null) {
                    DeltaPoseComposite.this.variable1ApogySystemApiAdapter.eAdapters().remove((Object)DeltaPoseComposite.this.getPoseAdapter());
                }
                if (DeltaPoseComposite.this.variable2ApogySystemApiAdapter != null) {
                    DeltaPoseComposite.this.variable2ApogySystemApiAdapter.eAdapters().remove((Object)DeltaPoseComposite.this.getPoseAdapter());
                }
            }
        });
    }

    public ApogySystemApiAdapter getVariable1ApogySystemApiAdapter() {
        return this.variable1ApogySystemApiAdapter;
    }

    public void setVariable1ApogySystemApiAdapter(ApogySystemApiAdapter apogySystemApiAdapter) {
        if (this.variable1ApogySystemApiAdapter != null) {
            this.variable1ApogySystemApiAdapter.eAdapters().remove((Object)this.getPoseAdapter());
        }
        this.variable1ApogySystemApiAdapter = apogySystemApiAdapter;
        if (this.variable1ApogySystemApiAdapter != null) {
            this.variable1ApogySystemApiAdapter.eAdapters().add((Object)this.getPoseAdapter());
        }
        this.updatePose();
    }

    public ApogySystemApiAdapter getVariable2ApogySystemApiAdapter() {
        return this.variable2ApogySystemApiAdapter;
    }

    public void setVariable2ApogySystemApiAdapter(ApogySystemApiAdapter apogySystemApiAdapter) {
        if (this.variable2ApogySystemApiAdapter != null) {
            this.variable2ApogySystemApiAdapter.eAdapters().remove((Object)this.getPoseAdapter());
        }
        this.variable2ApogySystemApiAdapter = apogySystemApiAdapter;
        if (this.variable2ApogySystemApiAdapter != null) {
            this.variable2ApogySystemApiAdapter.eAdapters().add((Object)this.getPoseAdapter());
        }
        this.updatePose();
    }

    protected void setDisplaysEnabled(boolean enabled) {
        if (this.textDistance != null && !this.textDistance.isDisposed()) {
            this.textDistance.setEnabled(enabled);
        }
        if (this.deltaDistanceComposite != null && !this.deltaDistanceComposite.isDisposed()) {
            this.deltaDistanceComposite.setEnabled(enabled);
        }
        if (this.deltaOrientationComposite != null && !this.deltaOrientationComposite.isDisposed()) {
            this.deltaOrientationComposite.setEnabled(enabled);
        }
    }

    protected void updatePose() {
        if (!this.isDisposed()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DeltaPoseComposite.this.setDisplaysEnabled(DeltaPoseComposite.this.variable1ApogySystemApiAdapter != null && DeltaPoseComposite.this.variable2ApogySystemApiAdapter != null);
                    if (DeltaPoseComposite.this.variable1ApogySystemApiAdapter != null && DeltaPoseComposite.this.variable2ApogySystemApiAdapter != null) {
                        Matrix4x4 variable2Pose;
                        Matrix4x4 variable1Pose = DeltaPoseComposite.this.variable1ApogySystemApiAdapter.getPoseTransform();
                        if (variable1Pose == null) {
                            variable1Pose = ApogyCommonMathFacade.INSTANCE.createIdentityMatrix4x4();
                        }
                        if ((variable2Pose = DeltaPoseComposite.this.variable2ApogySystemApiAdapter.getPoseTransform()) == null) {
                            variable2Pose = ApogyCommonMathFacade.INSTANCE.createIdentityMatrix4x4();
                        }
                        Tuple3d variable1Position = ApogyCommonMathFacade.INSTANCE.extractPosition(variable1Pose);
                        Point3d p1 = new Point3d(variable1Position.asTuple3d());
                        Tuple3d variable2Position = ApogyCommonMathFacade.INSTANCE.extractPosition(variable2Pose);
                        Point3d p2 = new Point3d(variable2Position.asTuple3d());
                        double distance = p1.distance(p2);
                        if (DeltaPoseComposite.this.textDistance != null && !DeltaPoseComposite.this.textDistance.isDisposed()) {
                            DeltaPoseComposite.this.textDistance.setText(DeltaPoseComposite.this.distanceFormat.format(distance));
                        }
                        double deltaX = p1.x - p2.x;
                        double deltaY = p1.y - p2.y;
                        double deltaZ = p1.z - p2.z;
                        Tuple3d deltaPosition = ApogyCommonMathFacade.INSTANCE.createTuple3d(deltaX, deltaY, deltaZ);
                        if (DeltaPoseComposite.this.deltaDistanceComposite != null && !DeltaPoseComposite.this.deltaDistanceComposite.isDisposed()) {
                            DeltaPoseComposite.this.deltaDistanceComposite.setTuple3d(deltaPosition);
                        }
                    }
                }
            });
        }
    }

    protected Adapter getPoseAdapter() {
        if (this.poseAdapter == null) {
            this.poseAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof PoseProvider) {
                        int featureID = msg.getFeatureID(PoseProvider.class);
                        switch (featureID) {
                            case 0: {
                                if (!(msg.getNewValue() instanceof Matrix4x4)) break;
                                DeltaPoseComposite.this.updatePose();
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.poseAdapter;
    }
}

