/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.apogy.core.ApogySystem;
import org.eclipse.apogy.core.AssemblyLink;
import org.eclipse.apogy.core.invocator.Type;
import org.eclipse.apogy.core.invocator.TypeMember;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jface.wizard.WizardPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAssemblyLinkWizardPage
extends WizardPage {
    private static final Logger Logger = LoggerFactory.getLogger(AbstractAssemblyLinkWizardPage.class);
    protected ApogySystem apogySystem;
    protected AssemblyLink assemblyLink;
    private List<AssemblyLink> allAssemblylinks;

    public AbstractAssemblyLinkWizardPage(String wizardPageId, ApogySystem apogySystem, AssemblyLink assemblyLink) {
        super(wizardPageId);
        this.apogySystem = apogySystem;
        this.assemblyLink = assemblyLink;
    }

    protected List<TypeMember> getAllTypeMembers(ApogySystem apogySystem) {
        ArrayList<TypeMember> list = new ArrayList<TypeMember>();
        for (TypeMember member : apogySystem.getMembers()) {
            list.addAll(this.recursiveGetAllTypeMembers(member));
        }
        return list;
    }

    protected List<TypeMember> recursiveGetAllTypeMembers(TypeMember typeMember) {
        ArrayList<TypeMember> list = new ArrayList<TypeMember>();
        list.add(typeMember);
        Type type = this.load(typeMember.getMemberType());
        if (type != null) {
            for (TypeMember member : type.getMembers()) {
                list.addAll(this.recursiveGetAllTypeMembers(member));
            }
        }
        return list;
    }

    protected List<AssemblyLink> getAllAssemblyLinks(ApogySystem apogySystem) {
        if (this.allAssemblylinks == null) {
            this.allAssemblylinks = new ArrayList<AssemblyLink>();
            List<TypeMember> allTypeMembers = this.getAllTypeMembers(apogySystem);
            if (apogySystem.getAssemblyLinksList() != null) {
                this.allAssemblylinks.addAll((Collection<AssemblyLink>)apogySystem.getAssemblyLinksList().getAssemblyLinks());
            }
            for (TypeMember typeMember : allTypeMembers) {
                ApogySystem system;
                Type type = this.load(typeMember.getMemberType());
                if (!(type instanceof ApogySystem) || (system = (ApogySystem)type).getAssemblyLinksList() == null) continue;
                this.allAssemblylinks.addAll((Collection<AssemblyLink>)system.getAssemblyLinksList().getAssemblyLinks());
            }
        }
        return this.allAssemblylinks;
    }

    protected Type load(Type type) {
        if (type != null && type.eIsProxy()) {
            Type loadedType = null;
            ResourceSet resourceSet = this.apogySystem.eResource().getResourceSet();
            Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
            Map m = reg.getExtensionToFactoryMap();
            m.put("*", new XMIResourceFactoryImpl());
            URI uri = EcoreUtil.getURI((EObject)type);
            Resource resource = resourceSet.getResource(uri, true);
            try {
                loadedType = (Type)resource.getContents().get(0);
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
            return loadedType;
        }
        return type;
    }
}

