/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.ui.wizards;

import org.eclipse.apogy.core.Activator;
import org.eclipse.apogy.core.WorksiteContributor;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.ui.composites.WorksiteContributorsListComposite;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ApogyWorksiteSelectionWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.ui.wizards.ApogyWorksiteSelectionWizardPage";
    private WorksiteContributorsListComposite listComposite;
    private static final String ERROR_MSG = "You must select one worksite";

    public ApogyWorksiteSelectionWizardPage() {
        super(WIZARD_PAGE_ID);
        this.setTitle("Select Registered Apogy Worksite");
        this.setDescription("This wizard allows to select a registered Apogy Worksite.");
        this.validate();
    }

    public void createControl(Composite parent) {
        this.listComposite = new WorksiteContributorsListComposite(parent, 0, Activator.getRegisteredWorksiteProviders()){

            @Override
            protected void newWorksiteContributorSelected(WorksiteContributor selectedWorksiteContributor) {
                ApogyWorksiteSelectionWizardPage.this.validate();
            }
        };
        this.setControl((Control)this.listComposite);
    }

    protected void validate() {
        String message = null;
        if (ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession() == null) {
            message = "There is no active Apogy Session.  Activate a session first.";
        } else if (this.getWorksiteContributor() == null) {
            message = ERROR_MSG;
        }
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public WorksiteContributor getWorksiteContributor() {
        return this.listComposite == null ? null : this.listComposite.getSelectedWorksiteContributor();
    }
}

