/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.ui.wizards;

import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.EditingDomainsValidity;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyPackage;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.composites.NodeSearchComposite;
import org.eclipse.apogy.common.topology.ui.dialogs.NodeSelectionDialog;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.ApogySystem;
import org.eclipse.apogy.core.ConnectionPoint;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ConnectionPointWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.ui.wizards.ConnectionPointWizardPage";
    private final ApogySystem apogySystem;
    private final ConnectionPoint connectionPoint;
    private Text txtNodeID;
    private Button btnSelectNode;

    public ConnectionPointWizardPage(ApogySystem apogySystem, ConnectionPoint connectionPoint) {
        super(WIZARD_PAGE_ID);
        this.apogySystem = apogySystem;
        this.connectionPoint = connectionPoint;
        this.setTitle("Connection Point refered Node");
        this.setDescription("Set the Connection Point refered Node in the Apogy System Topology.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(container, 0);
        label.setText("Refered Node ID : ");
        this.txtNodeID = new Text(container, 2048);
        this.txtNodeID.setEditable(false);
        GridData gd_lblFromNodeID = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblFromNodeID.minimumWidth = 250;
        gd_lblFromNodeID.widthHint = 250;
        this.txtNodeID.setLayoutData((Object)gd_lblFromNodeID);
        this.btnSelectNode = new Button(container, 0);
        this.btnSelectNode.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.btnSelectNode.setText("Select");
        this.btnSelectNode.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Node fromNode;
                final Node root = ConnectionPointWizardPage.this.apogySystem.getTopologyRoot().getOriginNode();
                NodeSelectionDialog nodeSelectionDialog = new NodeSelectionDialog(ConnectionPointWizardPage.this.getShell(), root){

                    protected NodeSearchComposite createNodeSearchComposite(Composite parent) {
                        NodeSearchComposite nodeSearchComposite = new NodeSearchComposite(parent, 0, root){

                            public void nodeSelectedChanged(Node nodeSelected) {
                                this.setSelectedNode(nodeSelected);
                            }
                        };
                        nodeSearchComposite.setTypeFilter(ApogyCommonTopologyPackage.Literals.GROUP_NODE);
                        return nodeSearchComposite;
                    }
                };
                if (nodeSelectionDialog.open() == 0 && (fromNode = nodeSelectionDialog.getSelectedNode()) instanceof GroupNode) {
                    GroupNode selectedNode = (GroupNode)fromNode;
                    if (ApogyCommonTransactionFacade.INSTANCE.areEditingDomainsValid((EObject)ConnectionPointWizardPage.this.connectionPoint, (EStructuralFeature)ApogyCorePackage.Literals.CONNECTION_POINT__NODE, (Object)selectedNode, false) == EditingDomainsValidity.EXECUTE_COMMAND_ON_OWNER_DOMAIN) {
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)ConnectionPointWizardPage.this.connectionPoint, (EStructuralFeature)ApogyCorePackage.Literals.CONNECTION_POINT__NODE, (Object)fromNode);
                    } else {
                        ConnectionPointWizardPage.this.connectionPoint.setNode(selectedNode);
                    }
                    ConnectionPointWizardPage.this.setErrorMessage(null);
                    ConnectionPointWizardPage.this.txtNodeID.setText(selectedNode.getNodeId());
                    ConnectionPointWizardPage.this.txtNodeID.setToolTipText(selectedNode.getNodeId());
                }
                if (ConnectionPointWizardPage.this.connectionPoint.getNode() == null) {
                    ConnectionPointWizardPage.this.setErrorMessage("No Node Selected !");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl((Control)container);
        this.setErrorMessage("No Node Selected !");
    }

    protected void validate() {
        this.setPageComplete(this.connectionPoint != null);
    }
}

