/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.ui.wizards;

import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.TreeRootNode;
import org.eclipse.apogy.common.emf.ui.composites.EClassSelectionComposite;
import org.eclipse.apogy.common.topology.AggregateGroupNode;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFactory;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.bindings.ApogyCommonTopologyBindingsFactory;
import org.eclipse.apogy.common.topology.bindings.BindingsSet;
import org.eclipse.apogy.common.topology.bindings.FeatureRootsList;
import org.eclipse.apogy.core.ApogyCoreFacade;
import org.eclipse.apogy.core.ApogyCoreFactory;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.ApogySystem;
import org.eclipse.apogy.core.TopologyRoot;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewApogySystemWizard
extends Wizard {
    private static final Logger Logger = LoggerFactory.getLogger(NewApogySystemWizard.class);
    private final ApogySystem apogySystem = ApogyCoreFactory.eINSTANCE.createApogySystem();
    private String fileAbsolutePath;

    public NewApogySystemWizard() {
        this.apogySystem.setName("<unamed>");
        this.apogySystem.setDescription("None.");
        TopologyRoot topologyRoot = ApogyCoreFactory.eINSTANCE.createTopologyRoot();
        AggregateGroupNode rootNode = ApogyCommonTopologyFactory.eINSTANCE.createAggregateGroupNode();
        rootNode.setNodeId("CHANGE_ME_TO_A_UNIQUE_ID");
        rootNode.setDescription("Root node of the Apogy System Topology.");
        topologyRoot.setOriginNode((Node)rootNode);
        this.apogySystem.setTopologyRoot(topologyRoot);
        this.apogySystem.setAssemblyLinksList(ApogyCoreFactory.eINSTANCE.createAssemblyLinksList());
        this.apogySystem.setConnectionPointsList(ApogyCoreFactory.eINSTANCE.createConnectionPointsList());
        BindingsSet bindingsSet = ApogyCommonTopologyBindingsFactory.eINSTANCE.createBindingsSet();
        bindingsSet.setBindingsList(ApogyCommonTopologyBindingsFactory.eINSTANCE.createBindingsList());
        FeatureRootsList featureRootsList = ApogyCommonTopologyBindingsFactory.eINSTANCE.createFeatureRootsList();
        featureRootsList.getFeatureRoots().add((Object)ApogyCommonEMFFactory.eINSTANCE.createTreeRootNode());
        bindingsSet.setFeatureRootsList(featureRootsList);
        this.apogySystem.setBindingSet(bindingsSet);
        this.apogySystem.setTypeApiAdapterClass(ApogyCorePackage.Literals.APOGY_SYSTEM_API_ADAPTER);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)new ApogySystemFilePathWizardPage());
        this.addPage((IWizardPage)new ApogySystemInterfaceClassPage());
    }

    public boolean canFinish() {
        return this.fileAbsolutePath != null && this.apogySystem.getInterfaceClass() != null;
    }

    public boolean performFinish() {
        if (this.getFileAbsolutePath() != null && this.getApogySystem() != null) {
            try {
                ApogyCoreFacade.INSTANCE.saveApogySystemToFile(this.getApogySystem(), this.getFileAbsolutePath());
                return true;
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public ApogySystem getApogySystem() {
        return this.apogySystem;
    }

    public String getFileAbsolutePath() {
        return this.fileAbsolutePath;
    }

    private class ApogySystemFilePathWizardPage
    extends WizardPage {
        private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.ui.wizards.ApogySystemFilePathWizardPage";
        private Label lblApogySystemFilePath;
        private Button btnOpen;

        public ApogySystemFilePathWizardPage() {
            super(WIZARD_PAGE_ID);
            this.setTitle("Apogy System File");
            this.setDescription("Select the path to the ApogySystem file to create.");
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(4, false));
            Label fileLabel = new Label(container, 0);
            fileLabel.setText("Apogy System File :");
            this.lblApogySystemFilePath = new Label(container, 2048);
            this.lblApogySystemFilePath.setText("");
            GridData gd_lblApogySystemFilePath = new GridData(4, 0x1000000, true, false);
            this.lblApogySystemFilePath.setLayoutData((Object)gd_lblApogySystemFilePath);
            this.btnOpen = new Button(container, 8);
            this.btnOpen.setText("Open");
            this.btnOpen.setToolTipText("Opens an existing Apogy System file.");
            GridData gd_btnOpen = new GridData(0x1000000, 128, false, false);
            this.btnOpen.setLayoutData((Object)gd_btnOpen);
            this.btnOpen.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    FileDialog fd = new FileDialog(ApogySystemFilePathWizardPage.this.getShell(), 8192);
                    fd.setText("Select an ApogySystem File");
                    String[] filterExt = new String[]{"*.ss"};
                    fd.setFilterExtensions(filterExt);
                    NewApogySystemWizard.this.fileAbsolutePath = fd.open();
                    if (NewApogySystemWizard.this.fileAbsolutePath != null) {
                        ApogySystemFilePathWizardPage.this.lblApogySystemFilePath.setText(NewApogySystemWizard.this.fileAbsolutePath);
                    } else {
                        ApogySystemFilePathWizardPage.this.lblApogySystemFilePath.setText("");
                    }
                    ApogySystemFilePathWizardPage.this.validate();
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
            this.setControl((Control)container);
            this.validate();
        }

        protected void validate() {
            String errorStr = null;
            if (NewApogySystemWizard.this.fileAbsolutePath == null) {
                errorStr = "A path must be provided.";
            }
            this.setErrorMessage(errorStr);
            this.setPageComplete(errorStr == null);
        }
    }

    private class ApogySystemInterfaceClassPage
    extends WizardPage {
        private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.ui.wizards.ApogySystemInterfaceClassPage";
        private EClassSelectionComposite comboApogySystemInterfaceClass;
        private EClassSelectionComposite comboApogySystemApiAdapterClass;
        private DataBindingContext m_bindingContext;

        public ApogySystemInterfaceClassPage() {
            super(WIZARD_PAGE_ID);
            this.setTitle("Apogy System Interface Class");
            this.setDescription("Select the Apogy System Interface Class.");
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(2, false));
            Label fileLabel = new Label(container, 0);
            fileLabel.setText("Interface Class :");
            this.comboApogySystemInterfaceClass = new EClassSelectionComposite(container, 0);
            this.comboApogySystemInterfaceClass.setToolTipText("The interface class this Apogy System is being used for.");
            GridData gd_comboApogySystemInterfaceClass = new GridData(16384, 128, false, false, 1, 1);
            gd_comboApogySystemInterfaceClass.widthHint = 250;
            gd_comboApogySystemInterfaceClass.minimumWidth = 250;
            this.comboApogySystemInterfaceClass.setLayoutData((Object)gd_comboApogySystemInterfaceClass);
            this.comboApogySystemInterfaceClass.getComboViewer().getCombo().addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    TreeRootNode treeRootNode = (TreeRootNode)NewApogySystemWizard.this.getApogySystem().getBindingSet().getFeatureRootsList().getFeatureRoots().get(0);
                    treeRootNode.setSourceClass(ApogySystemInterfaceClassPage.this.comboApogySystemInterfaceClass.getSelectedEclass());
                    ApogySystemInterfaceClassPage.this.validate();
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
            Label apiAdapterLabel = new Label(container, 0);
            apiAdapterLabel.setText("API Adapter Class :");
            this.comboApogySystemApiAdapterClass = new EClassSelectionComposite(container, 0, ApogyCorePackage.Literals.APOGY_SYSTEM_API_ADAPTER);
            this.comboApogySystemApiAdapterClass.setToolTipText("The ApiAdapter to used for this system.");
            GridData gd_comboApogySystemApiAdapterClass = new GridData(16384, 128, false, false, 1, 1);
            gd_comboApogySystemApiAdapterClass.minimumWidth = 250;
            gd_comboApogySystemApiAdapterClass.widthHint = 250;
            this.comboApogySystemApiAdapterClass.setLayoutData((Object)gd_comboApogySystemApiAdapterClass);
            this.comboApogySystemApiAdapterClass.getComboViewer().getCombo().addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    ApogySystemInterfaceClassPage.this.validate();
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
            this.m_bindingContext = this.initDataBindingsCustom();
            this.setControl((Control)container);
            container.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (ApogySystemInterfaceClassPage.this.m_bindingContext != null) {
                        ApogySystemInterfaceClassPage.this.m_bindingContext.dispose();
                    }
                }
            });
            this.validate();
        }

        protected void validate() {
            String errorStr = null;
            if (NewApogySystemWizard.this.apogySystem.getInterfaceClass() == null) {
                errorStr = "An Interface Class must be provided.";
            }
            if (NewApogySystemWizard.this.apogySystem.getTypeApiAdapterClass() == null) {
                errorStr = "An Api Adapter Class must be provided.";
            }
            this.setErrorMessage(errorStr);
            this.setPageComplete(errorStr == null);
        }

        private DataBindingContext initDataBindingsCustom() {
            DataBindingContext bindingContext = new DataBindingContext();
            IObservableValue observeInterfaceClass = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain(), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreInvocatorPackage.Literals.TYPE__INTERFACE_CLASS})).observe((Object)NewApogySystemWizard.this.getApogySystem());
            IViewerObservableValue observeInterfaceClassComboViewer = ViewerProperties.singleSelection().observe((Viewer)this.comboApogySystemInterfaceClass.getComboViewer());
            bindingContext.bindValue((IObservableValue)observeInterfaceClassComboViewer, observeInterfaceClass, new UpdateValueStrategy(), new UpdateValueStrategy());
            IObservableValue observeApiAdapterClass = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain(), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreInvocatorPackage.Literals.TYPE__TYPE_API_ADAPTER_CLASS})).observe((Object)NewApogySystemWizard.this.getApogySystem());
            IViewerObservableValue observeApiAdapterClassComboViewer = ViewerProperties.singleSelection().observe((Viewer)this.comboApogySystemApiAdapterClass.getComboViewer());
            bindingContext.bindValue((IObservableValue)observeApiAdapterClassComboViewer, observeApiAdapterClass, new UpdateValueStrategy(), new UpdateValueStrategy());
            return bindingContext;
        }
    }
}

