/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.telecoms;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TelecomNodeStatus implements Enumerator
{
    NOT_STARTED(0, "NOT_STARTED", "Not Started"),
    NOT_ENABLED(1, "NOT_ENABLED", "Not Enabled"),
    UNREACHABLE(2, "UNREACHABLE", "Unreachable"),
    NORMAL(3, "NORMAL", "Normal"),
    PACKET_LOSS_WARNING(4, "PACKET_LOSS_WARNING", "Warning: High Packet Loss"),
    PACKET_LOSS_ALARM(5, "PACKET_LOSS_ALARM", "Alarm: Packet Loss Out Of Valid Range"),
    LATENCY_WARNING(6, "LATENCY_WARNING", "Warning: High Latency"),
    LATENCY_ALARM(7, "LATENCY_ALARM", "Alarm: Latency Out Of Valid Range"),
    BOTH_WARNING(8, "BOTH_WARNING", "Warning: High Latency & Packet Loss"),
    BOTH_ALARM(9, "BOTH_ALARM", "Alarm: Latency & Packet Loss Out Of Valid Range");

    public static final int NOT_STARTED_VALUE = 0;
    public static final int NOT_ENABLED_VALUE = 1;
    public static final int UNREACHABLE_VALUE = 2;
    public static final int NORMAL_VALUE = 3;
    public static final int PACKET_LOSS_WARNING_VALUE = 4;
    public static final int PACKET_LOSS_ALARM_VALUE = 5;
    public static final int LATENCY_WARNING_VALUE = 6;
    public static final int LATENCY_ALARM_VALUE = 7;
    public static final int BOTH_WARNING_VALUE = 8;
    public static final int BOTH_ALARM_VALUE = 9;
    private static final TelecomNodeStatus[] VALUES_ARRAY;
    public static final List<TelecomNodeStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TelecomNodeStatus[]{NOT_STARTED, NOT_ENABLED, UNREACHABLE, NORMAL, PACKET_LOSS_WARNING, PACKET_LOSS_ALARM, LATENCY_WARNING, LATENCY_ALARM, BOTH_WARNING, BOTH_ALARM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TelecomNodeStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TelecomNodeStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TelecomNodeStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TelecomNodeStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TelecomNodeStatus get(int value) {
        switch (value) {
            case 0: {
                return NOT_STARTED;
            }
            case 1: {
                return NOT_ENABLED;
            }
            case 2: {
                return UNREACHABLE;
            }
            case 3: {
                return NORMAL;
            }
            case 4: {
                return PACKET_LOSS_WARNING;
            }
            case 5: {
                return PACKET_LOSS_ALARM;
            }
            case 6: {
                return LATENCY_WARNING;
            }
            case 7: {
                return LATENCY_ALARM;
            }
            case 8: {
                return BOTH_WARNING;
            }
            case 9: {
                return BOTH_ALARM;
            }
        }
        return null;
    }

    private TelecomNodeStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

