/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.telecoms.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.addons.SimpleTool;
import org.eclipse.apogy.addons.telecoms.ApogyAddonsTelecomsFactory;
import org.eclipse.apogy.addons.telecoms.TelecomStatusMonitorTool;
import org.eclipse.apogy.addons.telecoms.TelecomStatusMonitorToolList;
import org.eclipse.apogy.addons.telecoms.impl.ApogyAddonsTelecomsFacadeImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.invocator.AbstractToolsListContainer;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyAddonsTelecomsFacadeCustomImpl
extends ApogyAddonsTelecomsFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyAddonsTelecomsFacadeCustomImpl.class);
    private Adapter activeSessionAdapter = null;

    public ApogyAddonsTelecomsFacadeCustomImpl() {
        ApogyCoreInvocatorFacade.INSTANCE.eAdapters().add((Object)this.getActiveSessionAdapter());
        this.setAvailableTelecomStatusMonitorTools(this.getAvailableTelecomStatusMonitorTools());
    }

    @Override
    public void activateEnabledTelecomStatusMonitorTools() {
        InvocatorSession session = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession();
        if (session != null) {
            this.activateEnabledTelecomStatusMonitorTools(session);
        }
    }

    @Override
    public TelecomStatusMonitorToolList getAvailableTelecomStatusMonitorTools() {
        InvocatorSession session;
        TelecomStatusMonitorToolList tmp = super.getAvailableTelecomStatusMonitorTools();
        if (tmp == null && (session = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession()) != null && (tmp = this.getTelecomStatusMonitorToolList(session)) == null) {
            tmp = ApogyAddonsTelecomsFactory.eINSTANCE.createTelecomStatusMonitorToolList();
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)session.getToolsList(), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.TOOLS_LIST__TOOLS_LIST_CONTAINERS, (Object)tmp, true);
        }
        return tmp;
    }

    @Override
    public List<TelecomStatusMonitorTool> getList(TelecomStatusMonitorToolList telecomStatusMonitorToolList) {
        ArrayList<TelecomStatusMonitorTool> tools = new ArrayList<TelecomStatusMonitorTool>();
        if (telecomStatusMonitorToolList != null) {
            for (SimpleTool simpleTool : telecomStatusMonitorToolList.getSimpleTools()) {
                if (!(simpleTool instanceof TelecomStatusMonitorTool)) continue;
                tools.add((TelecomStatusMonitorTool)simpleTool);
            }
        }
        return tools;
    }

    private TelecomStatusMonitorToolList getTelecomStatusMonitorToolList(InvocatorSession session) {
        TelecomStatusMonitorToolList telecomStatusMonitorToolList = null;
        if (session != null) {
            Iterator it = session.getToolsList().getToolsListContainers().iterator();
            while (it.hasNext() && telecomStatusMonitorToolList == null) {
                AbstractToolsListContainer container = (AbstractToolsListContainer)it.next();
                if (!(container instanceof TelecomStatusMonitorToolList)) continue;
                telecomStatusMonitorToolList = (TelecomStatusMonitorToolList)container;
            }
        }
        return telecomStatusMonitorToolList;
    }

    private void activateEnabledTelecomStatusMonitorTools(InvocatorSession session) {
        TelecomStatusMonitorToolList telecomStatusMonitorToolList = this.getTelecomStatusMonitorToolList(session);
        if (telecomStatusMonitorToolList != null) {
            List<TelecomStatusMonitorTool> tools = this.getList(telecomStatusMonitorToolList);
            for (TelecomStatusMonitorTool tool : tools) {
                try {
                    if (tool.isEnabled()) {
                        tool.start();
                        continue;
                    }
                    tool.stop();
                }
                catch (Exception e) {
                    Logger.error("Failed to activate TelecomStatusMonitorTool <" + tool.getName() + ">!", (Throwable)e);
                }
            }
        }
    }

    private void dipsoseOfTools(InvocatorSession session) {
        TelecomStatusMonitorToolList telecomStatusMonitorToolList = this.getTelecomStatusMonitorToolList(session);
        if (telecomStatusMonitorToolList != null) {
            List<TelecomStatusMonitorTool> tools = this.getList(telecomStatusMonitorToolList);
            for (TelecomStatusMonitorTool tool : tools) {
                try {
                    tool.dispose();
                }
                catch (Exception e) {
                    Logger.error("Failed to dispose of TelecomStatusMonitorTool <" + tool.getName() + ">!", (Throwable)e);
                }
            }
        }
    }

    private Adapter getActiveSessionAdapter() {
        if (this.activeSessionAdapter == null) {
            this.activeSessionAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureID;
                    if (msg.getNotifier() instanceof ApogyCoreInvocatorFacade && (featureID = msg.getFeatureID(ApogyCoreInvocatorFacade.class)) == 2) {
                        ApogyAddonsTelecomsFacadeCustomImpl.this.setAvailableTelecomStatusMonitorTools(null);
                        if (msg.getOldValue() instanceof InvocatorSession) {
                            InvocatorSession oldInvocatorSession = (InvocatorSession)msg.getOldValue();
                            ApogyAddonsTelecomsFacadeCustomImpl.this.dipsoseOfTools(oldInvocatorSession);
                        }
                        if (msg.getNewValue() instanceof InvocatorSession) {
                            InvocatorSession newInvocatorSession = (InvocatorSession)msg.getNewValue();
                            ApogyAddonsTelecomsFacadeCustomImpl.this.activateEnabledTelecomStatusMonitorTools(newInvocatorSession);
                            ApogyAddonsTelecomsFacadeCustomImpl.this.setAvailableTelecomStatusMonitorTools(ApogyAddonsTelecomsFacadeCustomImpl.this.getTelecomStatusMonitorToolList(newInvocatorSession));
                        }
                    }
                }
            };
        }
        return this.activeSessionAdapter;
    }
}

