/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.telecoms.impl;

import org.eclipse.apogy.addons.telecoms.impl.DipoleAntennaRadiationPatternImpl;

public class DipoleAntennaRadiationPatternCustomImpl
extends DipoleAntennaRadiationPatternImpl {
    boolean integralDirty = true;
    double integral = 1.0;

    @Override
    public void setDipoleLength(double newDipoleLength) {
        super.setDipoleLength(newDipoleLength);
        this.integralDirty = true;
    }

    @Override
    public double computeGain(double theta, double phi) {
        return this.computeGainDev(theta, phi);
    }

    public double computeGainDev(double theta, double phi) {
        if (theta != 0.0) {
            if (this.integralDirty) {
                this.integral = this.computeIntegral();
                this.integralDirty = false;
            }
            double directivity = 2.0 * this.F(theta) / this.integral;
            return directivity;
        }
        return 1.0E-10;
    }

    private double F(double theta) {
        double L = this.getDipoleLength();
        if (theta != 0.0) {
            return (Math.cos(L / 2.0 * Math.cos(theta)) - Math.cos(L / 2.0)) / Math.sin(theta) * ((Math.cos(L / 2.0 * Math.cos(theta)) - Math.cos(L / 2.0)) / Math.sin(theta));
        }
        return 0.0;
    }

    private double FSinTheta(double theta) {
        return this.F(theta) * Math.sin(theta);
    }

    private double computeIntegral() {
        double epsilon;
        double a = epsilon = 0.001;
        double b = Math.PI - epsilon;
        int n = 180;
        double h = (b - a) / (double)(n - 1);
        double integral = this.FSinTheta(a) + this.FSinTheta(b);
        double x = a;
        int j = 2;
        while (j < n - 1) {
            x = a + h * (double)j;
            integral += 2.0 * this.FSinTheta(x);
            j += 2;
        }
        j = 1;
        while (j < n - 1) {
            x = a + h * (double)j;
            integral += 4.0 * this.FSinTheta(x);
            j += 2;
        }
        return h / 3.0 * integral;
    }
}

