/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.atmosphere.impl;

import java.util.Date;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFacade;
import org.eclipse.apogy.core.environment.Sky;
import org.eclipse.apogy.core.environment.Worksite;
import org.eclipse.apogy.core.environment.earth.atmosphere.ApogyEarthAtmosphereEnvironmentFactory;
import org.eclipse.apogy.core.environment.earth.atmosphere.EarthAtmosphereWorksite;
import org.eclipse.apogy.core.environment.earth.atmosphere.impl.ApogyEarthAtmosphereFacadeImpl;
import org.eclipse.apogy.core.environment.earth.surface.ApogyEarthSurfaceEnvironmentFacade;
import org.eclipse.apogy.core.environment.earth.surface.EarthSky;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyEarthAtmosphereFacadeCustomImpl
extends ApogyEarthAtmosphereFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyEarthAtmosphereFacadeImpl.class);
    private Adapter activeWorksiteAdapter = null;

    protected ApogyEarthAtmosphereFacadeCustomImpl() {
        ApogyCoreEnvironmentFacade.INSTANCE.eAdapters().add((Object)this.getWorksiteAdapter());
        if (ApogyCoreEnvironmentFacade.INSTANCE.getActiveWorksite() instanceof EarthAtmosphereWorksite) {
            this.setActiveEarthAtmosphereWorksite((EarthAtmosphereWorksite)ApogyCoreEnvironmentFacade.INSTANCE.getActiveWorksite());
        }
    }

    @Override
    public EarthAtmosphereWorksite createAndInitializeDefaultCSAEarthAtmosphereWorksite() {
        EarthAtmosphereWorksite worksite = null;
        try {
            Date now = new Date();
            worksite = ApogyEarthAtmosphereEnvironmentFactory.eINSTANCE.createEarthAtmosphereWorksite();
            worksite.setName("CSA AT");
            worksite.setDescription("The CSA Default Worksite.");
            worksite.setGeographicalCoordinates(ApogyEarthSurfaceEnvironmentFacade.INSTANCE.getMarsYardGeographicalCoordinates());
            EarthSky earthSky = ApogyEarthSurfaceEnvironmentFacade.INSTANCE.createEarthSky(worksite.getGeographicalCoordinates());
            worksite.setSky((Sky)earthSky);
            earthSky.setWorksite((Worksite)worksite);
            worksite.getEarthSky().setTime(now);
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        return worksite;
    }

    private Adapter getWorksiteAdapter() {
        if (this.activeWorksiteAdapter == null) {
            this.activeWorksiteAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof ApogyCoreEnvironmentFacade) {
                        int featureID = msg.getFeatureID(ApogyCoreEnvironmentFacade.class);
                        switch (featureID) {
                            case 1: {
                                if (msg.getNewValue() == null) {
                                    ApogyEarthAtmosphereFacadeCustomImpl.this.setActiveEarthAtmosphereWorksite(null);
                                    break;
                                }
                                if (!(msg.getNewValue() instanceof EarthAtmosphereWorksite)) break;
                                ApogyEarthAtmosphereFacadeCustomImpl.this.setActiveEarthAtmosphereWorksite((EarthAtmosphereWorksite)msg.getNewValue());
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.activeWorksiteAdapter;
    }
}

