/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.composites;

import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard;
import org.eclipse.apogy.common.processors.ApogyCommonProcessorsPackage;
import org.eclipse.apogy.core.environment.earth.orbit.AbstractOrbitAnalysisProcessor;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFacade;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitPackage;
import org.eclipse.apogy.core.environment.earth.orbit.OrbitAnalysisData;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractOrbitAnalysisProcessorsListComposite
extends EMFFormsEListComposite<OrbitAnalysisData, OrbitAnalysisData, AbstractOrbitAnalysisProcessor> {
    private static final Logger Logger = LoggerFactory.getLogger(AbstractOrbitAnalysisProcessorsListComposite.class);
    private Job processorJob;

    public AbstractOrbitAnalysisProcessorsListComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    protected void createButtons(Composite parent, int style) {
        this.createNewButton(parent, style);
        this.createDeleteButton(parent, style);
        this.createUpButton(parent, style);
        this.createDownButton(parent, style);
        this.createCopyButton(parent, style);
        this.createSeparator(parent, style);
        this.createActivateButton(parent, style);
    }

    protected Button createStopButton(Composite parent, int style) {
        Button button = super.createStopButton(parent, style);
        button.setText("Cancel");
        return button;
    }

    protected void createStartButtonBindings(Button button) {
        IObservableValue observeRunning = EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreEnvironmentEarthOrbitPackage.Literals.ORBIT_ANALYSIS_DATA__ACTIVE_PROCESSOR, ApogyCommonProcessorsPackage.Literals.PROCESSOR__RUNNING})).observeDetail((IObservableValue)this.getRootEObjectWritableValue());
        ISWTObservableValue observeButtonEnabled = WidgetProperties.enabled().observe((Widget)button);
        IConverter converter = IConverter.create(Boolean.class, Boolean.class, o -> {
            if (this.getRootEObject() != null && ((OrbitAnalysisData)this.getRootEObject()).getActiveProcessor() != null && !((OrbitAnalysisData)this.getRootEObject()).getActiveProcessor().isRunning()) {
                return true;
            }
            return false;
        });
        this.getDataBindingContext().bindValue((IObservableValue)observeButtonEnabled, observeRunning, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), UpdateValueStrategy.create((IConverter)converter));
    }

    protected void createStopButtonBindings(Button button) {
        IObservableValue observeRunning = EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreEnvironmentEarthOrbitPackage.Literals.ORBIT_ANALYSIS_DATA__ACTIVE_PROCESSOR, ApogyCommonProcessorsPackage.Literals.PROCESSOR__RUNNING})).observeDetail((IObservableValue)this.getRootEObjectWritableValue());
        ISWTObservableValue observeButtonEnabled = WidgetProperties.enabled().observe((Widget)button);
        this.getDataBindingContext().bindValue((IObservableValue)observeButtonEnabled, observeRunning, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Boolean.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (AbstractOrbitAnalysisProcessorsListComposite.this.getResolvedEObject() != null && ((OrbitAnalysisData)AbstractOrbitAnalysisProcessorsListComposite.this.getRootEObject()).getActiveProcessor() != null && ((OrbitAnalysisData)AbstractOrbitAnalysisProcessorsListComposite.this.getRootEObject()).getActiveProcessor().isRunning()) {
                    return true;
                }
                return false;
            }
        }));
    }

    protected void doActivate(List<AbstractOrbitAnalysisProcessor> list) {
        ApogyCommonTransactionFacade.INSTANCE.basicSet(this.getResolvedEObject(), (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ORBIT_ANALYSIS_DATA__ACTIVE_PROCESSOR, (Object)list.get(0), true);
    }

    protected void doNew() {
        new WizardDialog(this.getShell(), (IWizard)new EObjectWizard((EObject)((OrbitAnalysisData)this.getRootEObject()), this.getFeaturePath(), (EReference)this.getEStructuralFeature(), ApogyCoreEnvironmentEarthOrbitPackage.Literals.ABSTRACT_ORBIT_ANALYSIS_PROCESSOR, null)).open();
    }

    protected void doCopy(AbstractOrbitAnalysisProcessor resolvedObject) {
        AbstractOrbitAnalysisProcessor copy = (AbstractOrbitAnalysisProcessor)EcoreUtil.copy((EObject)resolvedObject);
        copy.setName(String.valueOf(copy.getName()) + "_COPY");
        ApogyCommonTransactionFacade.INSTANCE.basicAdd(this.getRootEObject(), (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPackage.Literals.ORBIT_ANALYSIS_DATA__PROCESSORS, (Object)copy, true);
    }

    protected void doStart(List<AbstractOrbitAnalysisProcessor> list) {
        OrbitAnalysisData orbitAnalysisData = (OrbitAnalysisData)this.getResolvedEObject();
        AbstractOrbitAnalysisProcessor processor = ((OrbitAnalysisData)this.getResolvedEObject()).getActiveProcessor();
        this.processorJob = Job.create((String)("Process (" + processor.getName() + ")"), monitor -> {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)processor, (EStructuralFeature)ApogyCommonProcessorsPackage.Literals.MONITORABLE__PROGRESS_MONITOR, (Object)monitor, true);
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)processor, (EStructuralFeature)ApogyCommonProcessorsPackage.Literals.PROCESSOR__INPUT, (Object)orbitAnalysisData, true);
            try {
                processor.process((Object)((OrbitAnalysisData)processor.getInput()));
            }
            catch (Exception e) {
                Logger.error("Process failed", (Object)e.getMessage());
            }
        });
        this.processorJob.setUser(true);
        this.processorJob.schedule();
    }

    protected void doStop(List<AbstractOrbitAnalysisProcessor> list) {
        try {
            ((OrbitAnalysisData)this.getResolvedEObject()).getActiveProcessor().cancel();
        }
        catch (Exception e) {
            Logger.error("Failed to cancel processor <" + ((OrbitAnalysisData)this.getResolvedEObject()).getActiveProcessor().getName() + "> !", (Throwable)e);
        }
    }

    protected AdapterFactoryLabelProvider.StyledLabelProvider createLabelProvider(AdapterFactory adapterFactory) {
        return new AdapterFactoryLabelProvider.StyledLabelProvider(adapterFactory, (Viewer)this.getViewer()){

            public String getText(Object object) {
                String text = super.getText(object);
                if (ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getOrbitAnalysisDataSet().getActiveData().getActiveProcessor() == object) {
                    text = "<Active> " + text;
                }
                return text;
            }
        };
    }
}

