/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.composites;

import java.text.DecimalFormat;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.core.environment.earth.orbit.Eclipse;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.widgets.Composite;

public class EclipsesListComposite<RootEObject extends EObject, ResolvedEObject extends EObject, ItemObject extends Eclipse>
extends EMFFormsEListComposite<RootEObject, ResolvedEObject, ItemObject> {
    public static final DecimalFormat DURATION_FORMAT = new DecimalFormat("0.00");
    private static final int ORBIT_MODEL_COL_MIN_WIDTH = 100;
    private static final int PENUMBRA_ENTRY_TIME_COL_MIN_WIDTH = 200;
    private static final int PENUMBRA_EXIT_TIME_COL_MIN_WIDTH = 200;
    private static final int PENUMBRA_DURATION_COL_MIN_WIDTH = 100;
    private static final int UMBRA_ENTRY_TIME_COL_MIN_WIDTH = 200;
    private static final int UMBRA_EXIT_TIME_COL_MIN_WIDTH = 200;
    private static final int UMBRA_DURATION_COL_MIN_WIDTH = 100;

    public EclipsesListComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn orbitModelTableViewerColumn = new TreeViewerColumn(viewer, 0);
        orbitModelTableViewerColumn.getColumn().setText("Spacecraft");
        orbitModelTableViewerColumn.getColumn().setAlignment(0x1000000);
        orbitModelTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Eclipse)element).getSpacecraft().getName();
            }
        });
        orbitModelTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        TreeViewerColumn penumbraEntryTimeTableViewerColumn = new TreeViewerColumn(viewer, 0);
        penumbraEntryTimeTableViewerColumn.getColumn().setText("Penumbra Entry");
        penumbraEntryTimeTableViewerColumn.getColumn().setAlignment(0x1000000);
        penumbraEntryTimeTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Eclipse eclipse = (Eclipse)element;
                if (eclipse.getPenumbraEntry() != null) {
                    if (eclipse.getPenumbraEntry().getTime() != null) {
                        return ApogyCommonEMFFacade.INSTANCE.format(eclipse.getPenumbraEntry().getTime());
                    }
                    return "?";
                }
                return "N/A";
            }
        });
        penumbraEntryTimeTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        TreeViewerColumn penumbraExitTimeTableViewerColumn = new TreeViewerColumn(viewer, 0);
        penumbraExitTimeTableViewerColumn.getColumn().setText("Penumbra Exit");
        penumbraExitTimeTableViewerColumn.getColumn().setAlignment(0x1000000);
        penumbraExitTimeTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Eclipse eclipse = (Eclipse)element;
                if (eclipse.getPenumbraExit() != null) {
                    if (eclipse.getPenumbraExit().getTime() != null) {
                        return ApogyCommonEMFFacade.INSTANCE.format(eclipse.getPenumbraExit().getTime());
                    }
                    return "?";
                }
                return "N/A";
            }
        });
        penumbraExitTimeTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        TreeViewerColumn penumbraDurationTableViewerColumn = new TreeViewerColumn(viewer, 0);
        penumbraDurationTableViewerColumn.getColumn().setText("(min)");
        penumbraDurationTableViewerColumn.getColumn().setAlignment(0x1000000);
        penumbraDurationTableViewerColumn.getColumn().setToolTipText("Penumbra Duration in minutes");
        penumbraDurationTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Eclipse) {
                    Eclipse eclipse = (Eclipse)element;
                    if (eclipse.getPenumbraEntry() != null && eclipse.getPenumbraExit() != null && eclipse.getPenumbraEntry().getTime() != null && eclipse.getPenumbraExit().getTime() != null) {
                        double duration = 1.6666666666666667E-5 * (double)(eclipse.getPenumbraExit().getTime().getTime() - eclipse.getPenumbraEntry().getTime().getTime());
                        return DURATION_FORMAT.format(duration);
                    }
                    return "N/A";
                }
                return "";
            }
        });
        penumbraDurationTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        TreeViewerColumn umbraEntryTimeTableViewerColumn = new TreeViewerColumn(viewer, 0);
        umbraEntryTimeTableViewerColumn.getColumn().setText("Umbra Entry");
        umbraEntryTimeTableViewerColumn.getColumn().setAlignment(0x1000000);
        umbraEntryTimeTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Eclipse eclipse = (Eclipse)element;
                if (eclipse.getUmbraEntry() != null) {
                    if (eclipse.getUmbraEntry().getTime() != null) {
                        return ApogyCommonEMFFacade.INSTANCE.format(eclipse.getUmbraEntry().getTime());
                    }
                    return "?";
                }
                return "N/A";
            }
        });
        umbraEntryTimeTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        TreeViewerColumn umbraExitTimeTableViewerColumn = new TreeViewerColumn(viewer, 0);
        umbraExitTimeTableViewerColumn.getColumn().setText("Umbra Exit");
        umbraExitTimeTableViewerColumn.getColumn().setAlignment(0x1000000);
        umbraExitTimeTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Eclipse eclipse = (Eclipse)element;
                if (eclipse.getUmbraExit() != null) {
                    if (eclipse.getUmbraExit().getTime() != null) {
                        return ApogyCommonEMFFacade.INSTANCE.format(eclipse.getUmbraExit().getTime());
                    }
                    return "?";
                }
                return "N/A";
            }
        });
        umbraExitTimeTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        TreeViewerColumn umbraDurationTableViewerColumn = new TreeViewerColumn(viewer, 0);
        umbraDurationTableViewerColumn.getColumn().setText("(min)");
        umbraDurationTableViewerColumn.getColumn().setAlignment(0x1000000);
        umbraDurationTableViewerColumn.getColumn().setToolTipText("Umbra Duration in minutes");
        umbraDurationTableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Eclipse eclipse = (Eclipse)element;
                if (eclipse.getUmbraEntry() != null && eclipse.getUmbraExit() != null && eclipse.getUmbraEntry().getTime() != null && eclipse.getUmbraExit().getTime() != null) {
                    double duration = 1.6666666666666667E-5 * (double)(eclipse.getUmbraExit().getTime().getTime() - eclipse.getUmbraEntry().getTime().getTime());
                    return DURATION_FORMAT.format(duration);
                }
                return "N/A";
            }
        });
        umbraDurationTableViewerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
    }
}

