/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.utils;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.ExtrudedPolygon;
import gov.nasa.worldwind.render.Polygon;
import gov.nasa.worldwind.render.Polyline;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFacade;
import org.eclipse.apogy.core.environment.earth.orbit.Corridor;
import org.eclipse.apogy.core.environment.earth.orbit.CorridorPoint;
import org.eclipse.apogy.core.environment.earth.orbit.OreKitBackedSpacecraftState;
import org.eclipse.apogy.core.environment.earth.ui.utils.WorldWindUtils;
import org.eclipse.apogy.core.environment.orbit.SpacecraftState;

public class WorldWindOrbitUtils {
    public static List<Polyline> createPolyLineFromGeographicCoordinatesListNoWrapAround(List<GeographicCoordinates> coordinatesList, int maximumNumberOfCoord) {
        List<GeographicCoordinates> coordinatesToDisplay = new ArrayList<GeographicCoordinates>();
        if (maximumNumberOfCoord > 0) {
            coordinatesToDisplay = WorldWindOrbitUtils.subSampleGeographicCoordinates(coordinatesList, maximumNumberOfCoord);
        } else {
            coordinatesToDisplay.addAll(coordinatesList);
        }
        ArrayList<Polyline> polylines = new ArrayList<Polyline>();
        LinkedList<Position> positions = new LinkedList<Position>();
        for (GeographicCoordinates coord : coordinatesList) {
            Position position = WorldWindUtils.convertToPosition((GeographicCoordinates)coord);
            if (positions.size() > 0) {
                double currentLongitude = position.longitude.getDegrees();
                double lastLongitude = ((Position)positions.getLast()).longitude.getDegrees();
                if (Math.signum(currentLongitude) != Math.signum(lastLongitude) && Math.abs(currentLongitude) > 90.0 && Math.abs(lastLongitude) > 90.0) {
                    Polyline polyline = new Polyline(positions);
                    polylines.add(polyline);
                    positions.clear();
                }
            }
            positions.add(position);
        }
        if (!positions.isEmpty()) {
            Polyline polyline = new Polyline(positions);
            polylines.add(polyline);
        }
        return polylines;
    }

    public static Polyline createPolyLine(List<SpacecraftState> spacecraftStates) throws Exception {
        LinkedList<Position> positions = new LinkedList<Position>();
        for (SpacecraftState ss : spacecraftStates) {
            if (!(ss instanceof OreKitBackedSpacecraftState)) continue;
            GeographicCoordinates coord = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.convertToGeographicCoordinates((OreKitBackedSpacecraftState)ss);
            Position position = WorldWindUtils.convertToPosition((GeographicCoordinates)coord);
            positions.add(position);
        }
        Polyline polyline = new Polyline(positions);
        return polyline;
    }

    public static List<Polyline> createPolyLineWithNoWrapAround(Collection<SpacecraftState> spacecraftStates, int maximumNumberOfStates) throws Exception {
        ArrayList<Polyline> polylines = new ArrayList();
        Collection<SpacecraftState> statesToUse = null;
        statesToUse = maximumNumberOfStates > 0 ? WorldWindOrbitUtils.subSampleSpacecraftState(spacecraftStates, maximumNumberOfStates) : spacecraftStates;
        LinkedList<Position> positions = new LinkedList<Position>();
        for (SpacecraftState ss : statesToUse) {
            if (!(ss instanceof OreKitBackedSpacecraftState)) continue;
            GeographicCoordinates coord = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.convertToGeographicCoordinates((OreKitBackedSpacecraftState)ss);
            positions.add(WorldWindUtils.convertToPosition((GeographicCoordinates)coord));
        }
        polylines = WorldWindUtils.removeWrapAround(positions);
        return polylines;
    }

    public static List<Polygon> createPolygons(Corridor corridor, double relativeElevation, int maximumNumberOfPolygons) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        Object corridorPointToDisplay = null;
        corridorPointToDisplay = maximumNumberOfPolygons > 0 ? WorldWindOrbitUtils.subSampleCorridorPoint((Collection<CorridorPoint>)corridor.getPoints(), maximumNumberOfPolygons) : corridor.getPoints();
        if (corridorPointToDisplay.size() > 1) {
            int index = 1;
            int maxIndex = corridorPointToDisplay.size() - 1;
            CorridorPoint p0 = (CorridorPoint)corridorPointToDisplay.get(0);
            while (index < maxIndex) {
                CorridorPoint p1 = (CorridorPoint)corridorPointToDisplay.get(index);
                Position p0Left = WorldWindOrbitUtils.convertToPositionWithForcedElevation(p0.getLeft(), relativeElevation);
                Position p0Right = WorldWindOrbitUtils.convertToPositionWithForcedElevation(p0.getRight(), relativeElevation);
                Position p1Left = WorldWindOrbitUtils.convertToPositionWithForcedElevation(p1.getLeft(), relativeElevation);
                Position p1Right = WorldWindOrbitUtils.convertToPositionWithForcedElevation(p1.getRight(), relativeElevation);
                ArrayList<Position> polygon0List = new ArrayList<Position>();
                polygon0List.add(p0Left);
                polygon0List.add(p0Right);
                polygon0List.add(p1Right);
                polygon0List.add(p1Left);
                Polygon polygon0 = new Polygon(polygon0List);
                polygons.add(polygon0);
                p0 = p1;
                ++index;
            }
        }
        return polygons;
    }

    public static List<Polyline> createPolylines(Corridor corridor, double relativeElevation, int maximumNumberOfPolygons) {
        ArrayList<Polyline> polylines = new ArrayList<Polyline>();
        Object corridorPointToDisplay = null;
        corridorPointToDisplay = maximumNumberOfPolygons > 0 ? WorldWindOrbitUtils.subSampleCorridorPoint((Collection<CorridorPoint>)corridor.getPoints(), maximumNumberOfPolygons) : corridor.getPoints();
        if (corridorPointToDisplay.size() > 1) {
            int index = 1;
            int maxIndex = corridorPointToDisplay.size() - 1;
            LinkedList<Position> positions = new LinkedList<Position>();
            CorridorPoint p0 = (CorridorPoint)corridorPointToDisplay.get(0);
            while (index < maxIndex) {
                List lines;
                positions.clear();
                CorridorPoint p1 = (CorridorPoint)corridorPointToDisplay.get(index);
                Position p0Left = WorldWindOrbitUtils.convertToPositionWithForcedElevation(p0.getLeft(), relativeElevation);
                Position p0Right = WorldWindOrbitUtils.convertToPositionWithForcedElevation(p0.getRight(), relativeElevation);
                Position p1Left = WorldWindOrbitUtils.convertToPositionWithForcedElevation(p1.getLeft(), relativeElevation);
                Position p1Right = WorldWindOrbitUtils.convertToPositionWithForcedElevation(p1.getRight(), relativeElevation);
                positions.add(p0Left);
                positions.add(p1Left);
                positions.add(p1Right);
                positions.add(p0Right);
                positions.add(p0Left);
                if (Math.signum(p0Left.getLongitude().degrees) != Math.signum(p1Left.getLongitude().degrees)) {
                    if (Math.abs(p0Left.longitude.degrees) < 90.0 && Math.abs(p1Left.longitude.degrees) < 90.0) {
                        positions.clear();
                        positions.add(p0Left);
                        positions.add(p1Left);
                        positions.add(p1Left);
                        positions.add(p1Right);
                        positions.add(p1Right);
                        positions.add(p0Right);
                        positions.add(p0Right);
                        positions.add(p0Left);
                        lines = WorldWindUtils.removeWrapAround(positions);
                        polylines.addAll(lines);
                    } else if (Math.abs(p0Left.longitude.degrees) > 90.0 && Math.abs(p1Left.longitude.degrees) > 90.0) {
                        positions.clear();
                        positions.add(p0Left);
                        positions.add(p0Right);
                        positions.add(p1Right);
                        positions.add(p1Left);
                        positions.add(p1Right);
                        positions.add(p1Left);
                        positions.add(p0Left);
                        positions.add(p1Left);
                        lines = WorldWindUtils.removeWrapAround(positions);
                        polylines.addAll(lines);
                    }
                } else {
                    lines = WorldWindUtils.removeWrapAround(positions);
                    polylines.addAll(lines);
                }
                p0 = p1;
                ++index;
            }
        }
        return polylines;
    }

    private static Position convertToPositionWithForcedElevation(GeographicCoordinates geographicCoordinates, double elevation) {
        Angle latitude = Angle.fromRadiansLatitude((double)geographicCoordinates.getLatitude());
        Angle longitude = Angle.fromRadiansLongitude((double)geographicCoordinates.getLongitude());
        Position position = new Position(latitude, longitude, elevation);
        return position;
    }

    public static List<ExtrudedPolygon> createExtrudedPolygons(Corridor corridor, double height) {
        ArrayList<ExtrudedPolygon> polygons = new ArrayList<ExtrudedPolygon>();
        if (corridor.getPoints().size() > 1) {
            int index = 1;
            int maxIndex = corridor.getPoints().size() - 1;
            CorridorPoint p0 = (CorridorPoint)corridor.getPoints().get(0);
            while (index <= maxIndex) {
                CorridorPoint p1 = (CorridorPoint)corridor.getPoints().get(index);
                Position p0Left = WorldWindUtils.convertToPosition((GeographicCoordinates)p0.getLeft());
                Position p0Right = WorldWindUtils.convertToPosition((GeographicCoordinates)p0.getRight());
                Position p1Left = WorldWindUtils.convertToPosition((GeographicCoordinates)p1.getLeft());
                Position p1Right = WorldWindUtils.convertToPosition((GeographicCoordinates)p1.getRight());
                ArrayList<Position> polygon0List = new ArrayList<Position>();
                polygon0List.add(p0Left);
                polygon0List.add(p0Right);
                polygon0List.add(p1Right);
                polygon0List.add(p1Left);
                ExtrudedPolygon polygon0 = new ExtrudedPolygon(polygon0List, Double.valueOf(height));
                polygons.add(polygon0);
                p0 = p1;
                ++index;
            }
        }
        return polygons;
    }

    public static List<SpacecraftState> subSampleSpacecraftState(Collection<SpacecraftState> originalSpacecraftStates, int maximumNumberOfStates) {
        SubSample<SpacecraftState> ss = new SubSample<SpacecraftState>();
        return ss.subSampleList(originalSpacecraftStates, maximumNumberOfStates);
    }

    public static List<GeographicCoordinates> subSampleGeographicCoordinates(Collection<GeographicCoordinates> originalGeographicCoordinates, int maximumNumberOfCoordinates) {
        SubSample<GeographicCoordinates> ss = new SubSample<GeographicCoordinates>();
        return ss.subSampleList(originalGeographicCoordinates, maximumNumberOfCoordinates);
    }

    public static List<CorridorPoint> subSampleCorridorPoint(Collection<CorridorPoint> originalCorridorPoints, int maximumNumberOfPoints) {
        SubSample<CorridorPoint> ss = new SubSample<CorridorPoint>();
        return ss.subSampleList(originalCorridorPoints, maximumNumberOfPoints);
    }

    public static class SubSample<T> {
        public List<T> subSampleList(Collection<T> originalSpacecraftStates, int maximumNumberOfStates) {
            ArrayList<T> subSampled = new ArrayList<T>();
            if (originalSpacecraftStates.size() <= maximumNumberOfStates) {
                subSampled.addAll(originalSpacecraftStates);
            } else {
                Iterator<T> it = originalSpacecraftStates.iterator();
                double ratio = (double)originalSpacecraftStates.size() / (double)maximumNumberOfStates;
                int step = (int)Math.ceil(ratio);
                int count = 0;
                while (it.hasNext()) {
                    T state = it.next();
                    if (count == 0) {
                        subSampled.add(state);
                    } else if (!it.hasNext()) {
                        subSampled.add(state);
                    } else if (Math.IEEEremainder(count, step) == 0.0) {
                        subSampled.add(state);
                    }
                    ++count;
                }
            }
            return subSampled;
        }
    }
}

