/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.ui.wizards;

import org.eclipse.apogy.core.environment.earth.orbit.AbstractTLE;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFacade;
import org.eclipse.apogy.core.environment.earth.orbit.TLE;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TLEBasicWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.environment.earth.orbit.ui.wizards.BasicTLEWizardPage";
    private AbstractTLE abstractTLE;
    private Text firstLineText;
    private Text secondLineText;

    public TLEBasicWizardPage(AbstractTLE abstractTLE) {
        super(WIZARD_PAGE_ID);
        this.abstractTLE = abstractTLE;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)container);
        Label firstLineLabel = new Label(container, 0);
        firstLineLabel.setText("First TLE Line:");
        firstLineLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.firstLineText = new Text(container, 2052);
        this.firstLineText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label secondLineLabel = new Label(container, 0);
        secondLineLabel.setText("Second TLE Line:");
        secondLineLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.secondLineText = new Text(container, 2052);
        this.secondLineText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.firstLineText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String newString;
                String text = TLEBasicWizardPage.this.firstLineText.getText();
                String s0 = text.substring(0, e.start);
                String s1 = text.substring(e.end);
                String firstLine = newString = String.valueOf(s0) + e.text + s1;
                String secondLine = TLEBasicWizardPage.this.secondLineText.getText();
                try {
                    TLEBasicWizardPage.this.updateAbstractTLE(TLEBasicWizardPage.this.abstractTLE, firstLine, secondLine);
                    TLEBasicWizardPage.this.firstLineText.setBackground(Display.getDefault().getSystemColor(5));
                    TLEBasicWizardPage.this.secondLineText.setBackground(Display.getDefault().getSystemColor(5));
                    TLEBasicWizardPage.this.setErrorMessage(null);
                }
                catch (Exception exception) {
                    TLEBasicWizardPage.this.firstLineText.setBackground(Display.getDefault().getSystemColor(3));
                    TLEBasicWizardPage.this.secondLineText.setBackground(Display.getDefault().getSystemColor(3));
                    TLEBasicWizardPage.this.setErrorMessage("The entered lines cannot be parsed to a TLE !");
                }
                TLEBasicWizardPage.this.validate();
            }
        });
        this.secondLineText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String text = TLEBasicWizardPage.this.firstLineText.getText();
                String s0 = text.substring(0, e.start);
                String s1 = text.substring(e.end);
                String newString = String.valueOf(s0) + e.text + s1;
                String firstLine = TLEBasicWizardPage.this.firstLineText.getText();
                String secondLine = newString;
                try {
                    TLEBasicWizardPage.this.updateAbstractTLE(TLEBasicWizardPage.this.abstractTLE, firstLine, secondLine);
                    TLEBasicWizardPage.this.firstLineText.setBackground(Display.getDefault().getSystemColor(5));
                    TLEBasicWizardPage.this.secondLineText.setBackground(Display.getDefault().getSystemColor(5));
                    TLEBasicWizardPage.this.setErrorMessage(null);
                }
                catch (Exception exception) {
                    TLEBasicWizardPage.this.firstLineText.setBackground(Display.getDefault().getSystemColor(3));
                    TLEBasicWizardPage.this.secondLineText.setBackground(Display.getDefault().getSystemColor(3));
                    TLEBasicWizardPage.this.setErrorMessage("The entered lines cannot be parsed to a TLE !");
                }
                TLEBasicWizardPage.this.validate();
            }
        });
        this.setErrorMessage("Please enter the first and second line of the TLE.");
        this.validate();
    }

    private void updateAbstractTLE(AbstractTLE abstractTLE, String firstLine, String secondLine) throws Exception {
        TLE newTLE = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.createTLE(firstLine, secondLine);
        ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.updateExistingTLE(abstractTLE, (AbstractTLE)newTLE);
    }

    protected void validate() {
        this.setPageComplete(this.getErrorMessage() == null);
    }
}

