/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.vehicle.ApogyAddonsVehiclePackage;
import org.eclipse.apogy.addons.vehicle.MeshNodeEntry;
import org.eclipse.apogy.addons.vehicle.Wheel;
import org.eclipse.apogy.addons.vehicle.impl.WheelContactProviderImpl;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianAxis;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.addons.dynamics.PhysicalBody;
import org.eclipse.emf.common.util.EList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WheelContactProviderCustomImpl
extends WheelContactProviderImpl {
    private static final Logger Logger = LoggerFactory.getLogger(WheelContactProviderImpl.class);

    @Override
    public List<PhysicalBody> extractContactBodies() {
        ArrayList<PhysicalBody> extractedWheels = new ArrayList<PhysicalBody>();
        try {
            Node root = this.getVehiclePoseCorrector().getSystemRootNode();
            EList nodes = ApogyCommonTopologyFacade.INSTANCE.findNodesByType(ApogyAddonsVehiclePackage.Literals.WHEEL, root);
            for (Node node : nodes) {
                if (!(node instanceof Wheel)) continue;
                extractedWheels.add((Wheel)node);
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        return extractedWheels;
    }

    @Override
    public void updateContactPoints(Matrix4x4 originalPose, Map<PhysicalBody, Point3d> bodyToContactsMap) {
        switch (this.getContactMode().getValue()) {
            case 0: {
                this.getWheelHubPositionPointWheelContact(originalPose, bodyToContactsMap);
                break;
            }
            case 1: {
                this.getWheelHubPositionCylindricalWheelContact(originalPose, bodyToContactsMap);
                break;
            }
        }
    }

    protected void getWheelHubPositionPointWheelContact(Matrix4x4 originalPose, Map<PhysicalBody, Point3d> wheelToContacts) {
        wheelToContacts.clear();
        EList<MeshNodeEntry> meshes = this.getVehiclePoseCorrector().getMeshes();
        for (MeshNodeEntry meshNodeEntry : meshes) {
            Matrix4d meshToWorld = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame(meshNodeEntry.getNode());
            ArrayList<CartesianPositionCoordinates> points = new ArrayList<CartesianPositionCoordinates>();
            for (PhysicalBody wheel : this.getVehiclePoseCorrector().getContactBodies()) {
                Matrix4d wheelTransform = ApogyCommonTopologyFacade.INSTANCE.expressInFrame((Node)wheel, meshNodeEntry.getNode());
                Vector3d wheelPosition = new Vector3d();
                wheelTransform.get(wheelPosition);
                points.add(ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(wheelPosition.x, wheelPosition.y, wheelPosition.z));
            }
            CartesianPositionCoordinates[] intersections = this.getProjectionAlongAxisOnToPolygon(CartesianAxis.Z, points, meshNodeEntry.getMesh());
            int i = 0;
            while (i < intersections.length) {
                PhysicalBody body;
                if (intersections[i] != null && (body = (PhysicalBody)this.getVehiclePoseCorrector().getContactBodies().get(i)) instanceof Wheel) {
                    Wheel wheel = (Wheel)body;
                    Point3d wheelPosition = new Point3d();
                    meshToWorld.transform(intersections[i].asPoint3d(), wheelPosition);
                    wheelPosition.z += wheel.getRadius();
                    if (wheelToContacts.get(wheel) != null) {
                        double previousZ = wheelToContacts.get((Object)wheel).z;
                        if (wheelPosition.getZ() > previousZ) {
                            wheelToContacts.put(wheel, wheelPosition);
                        }
                    } else {
                        wheelToContacts.put(wheel, wheelPosition);
                    }
                }
                ++i;
            }
        }
    }

    protected void getWheelHubPositionCylindricalWheelContact(Matrix4x4 originalPose, Map<PhysicalBody, Point3d> wheelToContacts) {
        wheelToContacts.clear();
    }
}

