/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.orbit.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.BillboardControl;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Sphere;
import com.jme3.util.BufferUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.apogy.core.environment.HorizontalCoordinates;
import org.eclipse.apogy.core.environment.earth.surface.orbit.ui.EarthOrbitingSpacecraftLocationTool;
import org.eclipse.apogy.core.environment.earth.surface.orbit.ui.EarthOrbitingSpacecraftLocationToolNode;
import org.eclipse.apogy.core.environment.earth.surface.orbit.ui.scene_objects.EarthOrbitingSpacecraftLocationToolNodeSceneObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class EarthOrbitingSpacecraftLocationToolJME3Object
extends DefaultJME3SceneObject<EarthOrbitingSpacecraftLocationToolNode>
implements IPropertyChangeListener,
EarthOrbitingSpacecraftLocationToolNodeSceneObject {
    public static final double SPACECRAFT_ANGULAR_DIAMETER_RADIANS = Math.toRadians(0.25);
    public static final double SPACECRAFT_TEXT_ANGULAR_HEIGHT_RADIANS = Math.toRadians(1.0);
    public static final ColorRGBA DEFAULT_GRID_COLOR = new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f);
    public static final float DISPLAY_RADIUS = 15000.0f;
    public static final int FONT_SIZE = Math.round(300.0f);
    private EarthOrbitingSpacecraftLocationTool earthOrbitingSpacecraftLocationTool;
    private Adapter adapter;
    private AssetManager assetManager = this.jme3Application.getAssetManager();
    private com.jme3.scene.Node spacecraftTransform = null;
    private Geometry spacecraftSphere;
    private com.jme3.scene.Node flag = null;
    private BillboardControl billboardControl;
    private Geometry flagGeometry = null;
    private Geometry vectorGeometry = null;

    public EarthOrbitingSpacecraftLocationToolJME3Object(EarthOrbitingSpacecraftLocationToolNode node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)node, jme3RenderEngineDelegate);
        this.assetManager.registerLocator("/", FileLocator.class);
        this.earthOrbitingSpacecraftLocationTool = node.getEarthOrbitingSpacecraftLocationTool();
        Job job = new Job("EarthOrbitModelPassToolNodeJME3Object initialize."){

            protected IStatus run(IProgressMonitor monitor) {
                EarthOrbitingSpacecraftLocationToolJME3Object.this.jme3Application.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        if (EarthOrbitingSpacecraftLocationToolJME3Object.this.earthOrbitingSpacecraftLocationTool != null) {
                            EarthOrbitingSpacecraftLocationToolJME3Object.this.getAttachmentNode().attachChild((Spatial)EarthOrbitingSpacecraftLocationToolJME3Object.this.getSpacecraftTransform());
                            EarthOrbitingSpacecraftLocationToolJME3Object.this.getSpacecraftTransform().attachChild((Spatial)EarthOrbitingSpacecraftLocationToolJME3Object.this.getFlag());
                            EarthOrbitingSpacecraftLocationToolJME3Object.this.createGeometry();
                            EarthOrbitingSpacecraftLocationToolJME3Object.this.earthOrbitingSpacecraftLocationTool.eAdapters().add((Object)EarthOrbitingSpacecraftLocationToolJME3Object.this.getAdapter());
                        }
                        return null;
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void updateGeometry(float tpf) {
        if (this.vectorGeometry != null) {
            this.getAttachmentNode().detachChild((Spatial)this.vectorGeometry);
        }
        this.vectorGeometry = this.createToolGeometry();
        if (this.earthOrbitingSpacecraftLocationTool.isShowVector()) {
            this.getAttachmentNode().attachChild((Spatial)this.vectorGeometry);
        }
    }

    public void dispose() {
        if (this.earthOrbitingSpacecraftLocationTool != null) {
            this.earthOrbitingSpacecraftLocationTool.eAdapters().remove((Object)this.getAdapter());
        }
        if (this.billboardControl != null) {
            this.billboardControl.setEnabled(false);
            this.billboardControl.setSpatial(null);
        }
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return null;
            }
        });
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.vectorGeometry);
        return geometries;
    }

    private void createGeometry() {
        this.vectorGeometry = this.createToolGeometry();
        this.getAttachmentNode().attachChild((Spatial)this.vectorGeometry);
    }

    private void updateName() {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                EarthOrbitingSpacecraftLocationToolJME3Object.this.getSpacecraftTransform().detachChild((Spatial)EarthOrbitingSpacecraftLocationToolJME3Object.this.getFlag());
                EarthOrbitingSpacecraftLocationToolJME3Object.this.getBillboardControl().setSpatial(null);
                EarthOrbitingSpacecraftLocationToolJME3Object.this.flag = null;
                if (EarthOrbitingSpacecraftLocationToolJME3Object.this.vectorGeometry != null) {
                    EarthOrbitingSpacecraftLocationToolJME3Object.this.getAttachmentNode().detachChild((Spatial)EarthOrbitingSpacecraftLocationToolJME3Object.this.vectorGeometry);
                }
                EarthOrbitingSpacecraftLocationToolJME3Object.this.vectorGeometry = EarthOrbitingSpacecraftLocationToolJME3Object.this.createToolGeometry();
                EarthOrbitingSpacecraftLocationToolJME3Object.this.getAttachmentNode().attachChild((Spatial)EarthOrbitingSpacecraftLocationToolJME3Object.this.vectorGeometry);
                return null;
            }
        });
    }

    private Geometry createToolGeometry() {
        HorizontalCoordinates spacecraftPosition = this.earthOrbitingSpacecraftLocationTool.getSpacecraftPosition();
        Geometry geometry = null;
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        geometry = new Geometry("SpacecraftVector", mesh);
        if (spacecraftPosition != null && spacecraftPosition.getAltitude() > 0.0) {
            ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
            ArrayList<Integer> indexesList = new ArrayList<Integer>();
            Vector3f p0 = new Vector3f(0.0f, 0.0f, 0.0f);
            double r = Math.cos(spacecraftPosition.getAltitude()) * 15000.0;
            float x = (float)(r * Math.cos(-spacecraftPosition.getAzimuth()));
            float y = (float)(r * Math.sin(-spacecraftPosition.getAzimuth()));
            float z = (float)(15000.0 * Math.sin(spacecraftPosition.getAltitude()));
            Vector3f p1 = new Vector3f(x, y, z);
            verticesList.add(p0);
            verticesList.add(p1);
            indexesList.add(0);
            indexesList.add(1);
            mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
            mesh.setBuffer(VertexBuffer.Type.Index, 2, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
            mesh.updateBound();
            mesh.updateCounts();
            if (!this.getSpacecraftTransform().hasChild((Spatial)this.getFlag())) {
                this.getSpacecraftTransform().attachChild((Spatial)this.getFlag());
            }
            this.getSpacecraftTransform().setLocalTranslation(x, y, z);
            if (!this.getSpacecraftTransform().hasChild((Spatial)this.getSpacecraftSphere())) {
                this.getSpacecraftTransform().attachChild((Spatial)this.getSpacecraftSphere());
            }
        } else {
            if (this.getSpacecraftTransform().hasChild((Spatial)this.getSpacecraftSphere())) {
                this.getSpacecraftTransform().detachChild((Spatial)this.getSpacecraftSphere());
            }
            if (this.getSpacecraftTransform().hasChild((Spatial)this.getFlag())) {
                this.getSpacecraftTransform().detachChild((Spatial)this.getFlag());
            }
        }
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", DEFAULT_GRID_COLOR.clone());
        geometry.setMaterial(mat);
        geometry.setShadowMode(RenderQueue.ShadowMode.Off);
        return geometry;
    }

    private com.jme3.scene.Node getSpacecraftTransform() {
        if (this.spacecraftTransform == null) {
            this.spacecraftTransform = new com.jme3.scene.Node("Spacecraft Transform");
        }
        return this.spacecraftTransform;
    }

    private Geometry getSpacecraftSphere() {
        if (this.spacecraftSphere == null) {
            float spacecraftRadius = (float)(15000.0 * Math.tan(SPACECRAFT_ANGULAR_DIAMETER_RADIANS / 2.0));
            Sphere sphere = new Sphere(10, 36, spacecraftRadius);
            Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
            mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
            this.spacecraftSphere = new Geometry("Spacecraft", (Mesh)sphere);
            this.spacecraftSphere.setMaterial(mat);
            this.spacecraftSphere.setShadowMode(RenderQueue.ShadowMode.Off);
        }
        return this.spacecraftSphere;
    }

    private BillboardControl getBillboardControl() {
        if (this.billboardControl == null) {
            this.billboardControl = new BillboardControl();
            this.billboardControl.setAlignment(BillboardControl.Alignment.Screen);
        }
        return this.billboardControl;
    }

    private com.jme3.scene.Node getFlag() {
        if (this.flag == null) {
            this.flag = this.createFlag(this.getFlagText(), FONT_SIZE);
        }
        return this.flag;
    }

    private com.jme3.scene.Node createFlag(String text, int fontSize) {
        com.jme3.scene.Node node = new com.jme3.scene.Node("Flag");
        node.setShadowMode(RenderQueue.ShadowMode.Off);
        com.jme3.scene.Node flagAttachmentPoint = new com.jme3.scene.Node("Flag Attachment Point");
        flagAttachmentPoint.setLocalTranslation(0.0f, 0.0f, 0.0f);
        node.attachChild((Spatial)flagAttachmentPoint);
        Font font = new Font("Serif", 1, fontSize);
        BufferedImage bufferedImage = this.createTextImage(text, font, 0);
        float widthToHeightRatio = (float)bufferedImage.getWidth() / (float)bufferedImage.getHeight();
        float flagHeight = (float)(15000.0 * Math.tan(SPACECRAFT_TEXT_ANGULAR_HEIGHT_RADIANS));
        float flagWidth = flagHeight * widthToHeightRatio;
        Mesh flagMesh = this.createFlagMesh(flagWidth, flagHeight);
        this.flagGeometry = new Geometry("Flag Geometry", flagMesh);
        Material mat = JME3Utilities.createMaterial((BufferedImage)bufferedImage, (AssetManager)this.assetManager);
        this.flagGeometry.setMaterial(mat);
        flagAttachmentPoint.addControl((Control)this.getBillboardControl());
        flagAttachmentPoint.attachChild((Spatial)this.flagGeometry);
        return node;
    }

    private Mesh createFlagMesh(float flagWidth, float flagHeight) {
        Vector3f[] vertices = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(flagWidth, 0.0f, 0.0f), new Vector3f(0.0f, flagHeight, 0.0f), new Vector3f(flagWidth, flagHeight, 0.0f)};
        int[] nArray = new int[6];
        nArray[0] = 2;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 3;
        nArray[5] = 2;
        int[] indexes = nArray;
        Vector2f[] texCoord = new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f), new Vector2f(0.0f, 1.0f), new Vector2f(1.0f, 1.0f)};
        Mesh mesh = new Mesh();
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((Vector3f[])vertices));
        mesh.setBuffer(VertexBuffer.Type.TexCoord, 2, BufferUtils.createFloatBuffer((Vector2f[])texCoord));
        mesh.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createIntBuffer((int[])indexes));
        mesh.updateBound();
        mesh.updateCounts();
        return mesh;
    }

    private String getFlagText() {
        String text = null;
        if (this.earthOrbitingSpacecraftLocationTool != null) {
            text = this.earthOrbitingSpacecraftLocationTool.getName();
        }
        if (text == null || text.length() == 0) {
            text = "?";
        }
        return text;
    }

    private BufferedImage createTextImage(String text, Font font, int borderWidth) {
        Color textColor = JME3Utilities.convertToAWTColor((ColorRGBA)DEFAULT_GRID_COLOR);
        Color backgroundColor = JME3Utilities.convertToAWTColor((ColorRGBA)ColorRGBA.Black);
        AbstractEImage original = EImagesUtilities.INSTANCE.createTextImage(text, font, textColor, backgroundColor, borderWidth);
        int[] borderColor = JME3Utilities.convertToColorIntRGBA((ColorRGBA)FLAG_POLE_COLOR);
        AbstractEImage imageWithBorder = EImagesUtilities.INSTANCE.addBorder(original, borderWidth, borderColor[0], borderColor[1], borderColor[2]);
        return imageWithBorder.asBufferedImage();
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof EarthOrbitingSpacecraftLocationTool) {
                        int featureId = msg.getFeatureID(EarthOrbitingSpacecraftLocationTool.class);
                        switch (featureId) {
                            case 14: {
                                EarthOrbitingSpacecraftLocationToolJME3Object.this.requestUpdate();
                                break;
                            }
                            case 6: {
                                boolean newVisible = msg.getNewBooleanValue();
                                EarthOrbitingSpacecraftLocationToolJME3Object.this.setVisible(newVisible);
                            }
                            case 1: {
                                EarthOrbitingSpacecraftLocationToolJME3Object.this.updateName();
                                break;
                            }
                            case 13: {
                                EarthOrbitingSpacecraftLocationToolJME3Object.this.requestUpdate();
                                break;
                            }
                        }
                    } else if (msg.getNotifier() instanceof EarthOrbitingSpacecraftLocationToolNode) {
                        int featureId = msg.getFeatureID(EarthOrbitingSpacecraftLocationToolNode.class);
                        switch (featureId) {
                            case 15: {
                                EarthOrbitingSpacecraftLocationToolNode old = (EarthOrbitingSpacecraftLocationToolNode)msg.getOldValue();
                                old.eAdapters().remove((Object)EarthOrbitingSpacecraftLocationToolJME3Object.this.getAdapter());
                                EarthOrbitingSpacecraftLocationToolJME3Object.this.earthOrbitingSpacecraftLocationTool = (EarthOrbitingSpacecraftLocationTool)msg.getNewValue();
                                if (EarthOrbitingSpacecraftLocationToolJME3Object.this.earthOrbitingSpacecraftLocationTool == null) break;
                                EarthOrbitingSpacecraftLocationToolJME3Object.this.earthOrbitingSpacecraftLocationTool.eAdapters().add((Object)EarthOrbitingSpacecraftLocationToolJME3Object.this.getAdapter());
                                EarthOrbitingSpacecraftLocationToolJME3Object.this.requestUpdate();
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

