/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CameraViewDisplayRotation implements Enumerator
{
    NONE(0, "NONE", "None"),
    CW_90_DEG(1, "CW_90_DEG", "Clockwise 90 deg"),
    CCW_90_DEG(2, "CCW_90_DEG", "Counter Clockwise 90 deg"),
    CW_180_DEG(3, "CW_180_DEG", "Clockwise 180 deg");

    public static final int NONE_VALUE = 0;
    public static final int CW_90_DEG_VALUE = 1;
    public static final int CCW_90_DEG_VALUE = 2;
    public static final int CW_180_DEG_VALUE = 3;
    private static final CameraViewDisplayRotation[] VALUES_ARRAY;
    public static final List<CameraViewDisplayRotation> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CameraViewDisplayRotation[]{NONE, CW_90_DEG, CCW_90_DEG, CW_180_DEG};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CameraViewDisplayRotation get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CameraViewDisplayRotation result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CameraViewDisplayRotation getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CameraViewDisplayRotation result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CameraViewDisplayRotation get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return CW_90_DEG;
            }
            case 2: {
                return CCW_90_DEG;
            }
            case 3: {
                return CW_180_DEG;
            }
        }
        return null;
    }

    private CameraViewDisplayRotation(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

