/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.commands;

import java.util.Iterator;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraImageAnnotation;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToggleCameraImageAnnotationVisibilityCommand
extends AbstractHandler
implements IHandler {
    private static final Logger Logger = LoggerFactory.getLogger(ToggleCameraImageAnnotationVisibilityCommand.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final Iterator selections = ((IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)).iterator();
        Job job = new Job("Toggle Camera Overlay Visibility."){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    while (true) {
                        if (!selections.hasNext()) {
                            return Status.OK_STATUS;
                        }
                        Object selection = selections.next();
                        if (!(selection instanceof CameraImageAnnotation)) continue;
                        try {
                            CameraImageAnnotation cameraImageAnnotation = (CameraImageAnnotation)selection;
                            cameraImageAnnotation.setVisible(!cameraImageAnnotation.isVisible());
                        }
                        catch (Throwable t) {
                            Logger.error(t.getMessage(), t);
                        }
                    }
                }
                catch (Throwable t) {
                    return new Status(4, "org.eclipse.apogy.addons.sensors.imaging.camera", "Failed to toggle overlay visibility !", t);
                }
            }
        };
        job.schedule();
        return null;
    }
}

