/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.composites;

import java.util.List;
import org.eclipse.apogy.addons.sensors.imaging.camera.ApogyAddonsSensorsImagingCameraPackage;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraViewConfiguration;
import org.eclipse.apogy.addons.sensors.imaging.camera.FilterList;
import org.eclipse.apogy.addons.sensors.imaging.camera.ImageFilter;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class FiltersListComposite
extends EMFFormsEListComposite<CameraViewConfiguration, FilterList, ImageFilter> {
    public FiltersListComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyAddonsSensorsImagingCameraPackage.Literals.CAMERA_VIEW_CONFIGURATION__FILTER_LIST}), (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.FILTER_LIST__IMAGE_FILTERS, settings);
    }

    public FiltersListComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        super(parent, style, featurePath, eStructuralFeature, null);
    }

    protected void createButtons(Composite parent, int style) {
        this.createActivateButton(parent, style);
        this.createDeActivateButton(parent, style);
        this.createSeparator(parent, style);
        this.createUpButton(parent, style);
        this.createDownButton(parent, style);
        this.createSeparator(parent, style);
        this.createNewButton(parent, style);
        this.createDeleteButton(parent, style);
    }

    protected Button createActivateButton(Composite parent, int style) {
        Button btnActivate = FiltersListComposite.createButton((Composite)parent, (int)0, (String)"Enable", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doActivate(this.getSelectedItemObjects());
            this.refreshViewer();
        }));
        this.createActivateButtonBindings(btnActivate);
        return btnActivate;
    }

    protected void createActivateButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (this.getViewer().getStructuredSelection().size() > 0) {
                return !((ImageFilter)this.getSelectedItemObjects().get(0)).isEnabled();
            }
            return false;
        });
    }

    protected void doActivate(final List<ImageFilter> list) {
        TransactionalEditingDomain transactionalEditingDomain = ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain(this.getRootEObject());
        RecordingCommand cmd = new RecordingCommand(transactionalEditingDomain){

            protected void doExecute() {
                for (ImageFilter imageFilter : list) {
                    try {
                        imageFilter.setEnabled(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        try {
            transactionalEditingDomain.getCommandStack().execute((Command)cmd);
        }
        catch (Throwable throwable) {}
    }

    protected Button createDeActivateButton(Composite parent, int style) {
        Button btnDeActivate = FiltersListComposite.createButton((Composite)parent, (int)0, (String)"Disable", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doDeActivate(this.getSelectedItemObjects());
            this.refreshViewer();
        }));
        this.createDeActivateButtonBindings(btnDeActivate);
        return btnDeActivate;
    }

    protected void createDeActivateButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (this.getViewer().getStructuredSelection().size() > 0) {
                return ((ImageFilter)this.getSelectedItemObjects().get(0)).isEnabled();
            }
            return false;
        });
    }

    protected void doDeActivate(final List<ImageFilter> list) {
        TransactionalEditingDomain transactionalEditingDomain = ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain(this.getRootEObject());
        RecordingCommand cmd = new RecordingCommand(transactionalEditingDomain){

            protected void doExecute() {
                for (ImageFilter imageFilter : list) {
                    try {
                        imageFilter.setEnabled(false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        try {
            transactionalEditingDomain.getCommandStack().execute((Command)cmd);
        }
        catch (Throwable throwable) {}
    }
}

