/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.handlers;

import java.awt.image.BufferedImage;
import org.eclipse.apogy.addons.sensors.imaging.ImageSnapshot;
import org.eclipse.apogy.addons.sensors.imaging.camera.parts.CameraViewPart;
import org.eclipse.apogy.common.ApogyCommonOSGiUtilities;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TakeSnaphotHandler {
    private String currentDirectory = System.getProperty("user.dir");
    private static final Logger Logger = LoggerFactory.getLogger(TakeSnaphotHandler.class);

    @CanExecute
    public boolean canExecute(MPart part) {
        if (part.getObject() instanceof CameraViewPart) {
            CameraViewPart viewPart = (CameraViewPart)part.getObject();
            return viewPart.getCameraViewConfiguration() != null;
        }
        return false;
    }

    @Execute
    public void execute(MPart part, MToolItem item) {
        block9: {
            if (part.getObject() instanceof CameraViewPart) {
                CameraViewPart viewPart = (CameraViewPart)part.getObject();
                try {
                    BufferedImage image;
                    ImageSnapshot imageSnapshot = viewPart.getCameraViewConfiguration().getCamera().getLatestImageSnapshot();
                    if (imageSnapshot == null || (image = imageSnapshot.getImage().asBufferedImage()) == null) break block9;
                    EImage eImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
                    eImage.setImageContent(image);
                    if (eImage == null) break block9;
                    if (viewPart.getCameraViewConfiguration().getImageAutoSaveFolderPath() != null && viewPart.getCameraViewConfiguration().getImageAutoSaveFolderPath().length() > 0) {
                        this.currentDirectory = viewPart.getCameraViewConfiguration().getImageAutoSaveFolderPath();
                    }
                    FileDialog fileChooser = new FileDialog(viewPart.getShell(), 8192);
                    fileChooser.setText("Saves image to file");
                    fileChooser.setFilterPath(this.currentDirectory);
                    fileChooser.setFileName(viewPart.getCameraViewConfiguration().getName());
                    fileChooser.setFilterExtensions(new String[]{"*.png;"});
                    String filename = fileChooser.open();
                    if (filename == null) break block9;
                    try {
                        if (filename.endsWith(".png")) {
                            this.saveImageInJob((AbstractEImage)eImage, filename, 5);
                        } else {
                            String fileExtension = "";
                            if (filename.lastIndexOf(".") > 0) {
                                fileExtension = filename.substring(filename.lastIndexOf("."));
                            }
                            String message = "Failed to save the image. The specified file extension <" + fileExtension + "> is not supported.";
                            Logger.error(message);
                            MessageBox messageBox = new MessageBox(viewPart.getShell(), 33);
                            messageBox.setMessage(message);
                            messageBox.open();
                        }
                    }
                    catch (Exception exception) {
                        Logger.error("Unable to save image to file <" + filename + ">.");
                    }
                    this.currentDirectory = fileChooser.getFilterPath();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void saveImageInJob(final AbstractEImage image, final String fileName, final int fileType) {
        UIJob job = new UIJob("Save Image to file <" + fileName + ">"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (fileType == 4) {
                        EImagesUtilities.INSTANCE.saveImageAsJPEG(fileName, image);
                    } else if (fileType == 5) {
                        EImagesUtilities.INSTANCE.saveImageAsPNG(fileName, image);
                    }
                    Logger.info("Sucessfully saved image to file <" + fileName + ">.");
                    Status status = new Status(0, ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(((Object)((Object)this)).getClass()), "Sucessfully saved image to file <" + fileName + ">.");
                    return status;
                }
                catch (Exception e) {
                    String message = "Failed to save the image to file <" + fileName + ">. The following exception was thrown : \n\n ";
                    Logger.error(message, (Throwable)e);
                    Status status = new Status(4, ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(((Object)((Object)this)).getClass()), message, (Throwable)e);
                    return status;
                }
            }
        };
        job.schedule();
    }
}

