/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.addons.sensors.imaging.camera.ApogyAddonsSensorsImagingCameraFactory;
import org.eclipse.apogy.addons.sensors.imaging.camera.ApogyAddonsSensorsImagingCameraPackage;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraOverlay;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraOverlayList;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraTool;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraViewConfiguration;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraViewConfigurationList;
import org.eclipse.apogy.addons.sensors.imaging.camera.impl.CameraViewUtilitiesImpl;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.invocator.AbstractToolsListContainer;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFactory;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.invocator.ToolsList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CameraViewUtilitiesCustomImpl
extends CameraViewUtilitiesImpl {
    @Override
    public String getCameraViewConfigurationIdentifier(CameraViewConfiguration cameraViewConfiguration) {
        if (cameraViewConfiguration != null) {
            return ApogyCommonEMFFacade.INSTANCE.getID((EObject)cameraViewConfiguration);
        }
        return null;
    }

    @Override
    public CameraViewConfiguration getActiveCameraViewConfiguration(String identifier) {
        CameraViewConfigurationList cameraViewConfigurationList;
        CameraViewConfiguration cameraViewConfiguration = null;
        if (identifier != null && (cameraViewConfigurationList = this.getActiveCameraViewConfigurationList()) != null) {
            Iterator it = cameraViewConfigurationList.getCameraViewConfigurations().iterator();
            while (cameraViewConfiguration == null && it.hasNext()) {
                CameraViewConfiguration next = (CameraViewConfiguration)it.next();
                if (this.getCameraViewConfigurationIdentifier(next).compareTo(identifier) != 0) continue;
                cameraViewConfiguration = next;
            }
        }
        return cameraViewConfiguration;
    }

    @Override
    public CameraViewConfigurationList getActiveCameraViewConfigurationList() {
        CameraViewConfigurationList cameraViewConfigurationList = null;
        InvocatorSession session = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession();
        if (session != null) {
            ToolsList toolsList = session.getToolsList();
            if (toolsList == null) {
                toolsList = ApogyCoreInvocatorFactory.eINSTANCE.createToolsList();
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)session, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.INVOCATOR_SESSION__TOOLS_LIST, (Object)toolsList);
            }
            Iterator it = toolsList.getToolsListContainers().iterator();
            while (cameraViewConfigurationList == null && it.hasNext()) {
                AbstractToolsListContainer abstractToolsListContainer = (AbstractToolsListContainer)it.next();
                if (!(abstractToolsListContainer instanceof CameraViewConfigurationList)) continue;
                cameraViewConfigurationList = (CameraViewConfigurationList)abstractToolsListContainer;
            }
            if (cameraViewConfigurationList == null) {
                cameraViewConfigurationList = ApogyAddonsSensorsImagingCameraFactory.eINSTANCE.createCameraViewConfigurationList();
                ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)toolsList, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.TOOLS_LIST__TOOLS_LIST_CONTAINERS, (Object)cameraViewConfigurationList);
            }
        }
        return cameraViewConfigurationList;
    }

    @Override
    public void addCameraTool(CameraViewConfiguration cameraViewConfiguration, CameraTool cameraTool) {
        cameraTool.initializeCamera(cameraViewConfiguration.getCamera());
        ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)cameraViewConfiguration.getToolList(), (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.CAMERA_TOOL_LIST__TOOLS, (Object)cameraTool);
    }

    @Override
    public void removeCameraTool(CameraViewConfiguration cameraViewConfiguration, CameraTool cameraTool) {
        if (cameraTool != null) {
            cameraTool.dispose();
        }
        ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)cameraViewConfiguration.getToolList(), (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.CAMERA_TOOL_LIST__TOOLS, (Object)cameraTool);
    }

    @Override
    public List<CameraOverlay> findByName(CameraOverlayList cameraOverlayList, String name, boolean exactMatch) {
        ArrayList<CameraOverlay> overlays = new ArrayList<CameraOverlay>();
        for (CameraOverlay overlay : cameraOverlayList.getOverlays()) {
            if (exactMatch) {
                if (overlay.getName() == null || overlay.getName().compareTo(name) != 0) continue;
                overlays.add(overlay);
                continue;
            }
            if (overlay.getName() == null || !overlay.getName().contains(name)) continue;
            overlays.add(overlay);
        }
        return overlays;
    }

    @Override
    public List<CameraOverlay> findByName(InvocatorSession session, String name, boolean exactMatch) {
        ArrayList<CameraOverlay> overlays = new ArrayList<CameraOverlay>();
        CameraViewConfigurationList cameraViewConfigurationList = this.getActiveCameraViewConfigurationList();
        if (cameraViewConfigurationList != null) {
            for (CameraViewConfiguration cameraViewConfiguration : cameraViewConfigurationList.getCameraViewConfigurations()) {
                if (cameraViewConfiguration.getOverlayList() == null) continue;
                overlays.addAll(this.findByName(cameraViewConfiguration.getOverlayList(), name, exactMatch));
            }
        }
        return overlays;
    }
}

