/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.parts;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraViewConfiguration;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraViewConfigurationList;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraViewUtilities;
import org.eclipse.apogy.common.topology.AbstractViewPoint;
import org.eclipse.apogy.common.topology.ArbitraryViewPoint;
import org.eclipse.apogy.common.topology.AttachedViewPoint;
import org.eclipse.e4.ui.di.AboutToHide;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class CameraViewConfigurationDynamicMenuContributions {
    @Inject
    private EModelService modelService;

    @AboutToShow
    public void aboutToShow(List<MMenuElement> items) {
        CameraViewConfigurationList cameraViewConfigurationList = CameraViewUtilities.INSTANCE.getActiveCameraViewConfigurationList();
        if (cameraViewConfigurationList != null) {
            this.populate(items);
        }
    }

    @AboutToHide
    public void aboutToHide(List<MMenuElement> items) {
    }

    protected void populate(List<MMenuElement> items) {
        for (MMenuElement child : items) {
            child.setToBeRendered(false);
            child.setVisible(false);
        }
        items.clear();
        CameraViewConfigurationList cameraViewConfigurationList = CameraViewUtilities.INSTANCE.getActiveCameraViewConfigurationList();
        for (CameraViewConfiguration cameraViewConfiguration : cameraViewConfigurationList.getCameraViewConfigurations()) {
            MDirectMenuItem dynamicItem = (MDirectMenuItem)this.modelService.createModelElement(MDirectMenuItem.class);
            dynamicItem.setLabel(cameraViewConfiguration.getName());
            dynamicItem.setContributionURI("bundleclass://org.eclipse.apogy.addons.sensors.imaging.camera/org.eclipse.apogy.addons.sensors.imaging.camera.handlers.SetActiveCameraViewConfigurationHandler");
            dynamicItem.setContributorURI("platform:/plugin/org.eclipse.apogy.addons.sensors.imaging.camera");
            dynamicItem.setToBeRendered(true);
            dynamicItem.getTransientData().put("cameraViewConfiguration", cameraViewConfiguration);
            items.add((MMenuElement)dynamicItem);
        }
    }

    protected String getIconURIForAbstractViewPoint(AbstractViewPoint abstractViewPoint) {
        String uri = null;
        if (abstractViewPoint instanceof ArbitraryViewPoint) {
            uri = "platform:/plugin/org.eclipse.apogy.common.topology.edit/icons/full/obj16/ArbitraryViewPoint.gif";
        } else if (abstractViewPoint instanceof AttachedViewPoint) {
            uri = "platform:/plugin/org.eclipse.apogy.common.topology.edit/icons/full/obj16/AttachedViewPoint.gif";
        }
        return uri;
    }
}

