/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.addons.dynamics;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.addons.dynamics.PhysicalBody;
import org.eclipse.apogy.common.topology.addons.dynamics.PhysicalBodyNodeMassVisitor;
import org.eclipse.apogy.common.topology.addons.dynamics.PhysicalProperties;

public class PhysicalBodyNodeCenterOfMassVisitor
extends PhysicalBodyNodeMassVisitor {
    protected Point3d temporaryCenterOfMassPosition = new Point3d();
    protected Node root;

    public PhysicalBodyNodeCenterOfMassVisitor() {
    }

    public PhysicalBodyNodeCenterOfMassVisitor(Node root) {
        this.setRoot(root);
    }

    public Node getRoot() {
        return this.root;
    }

    public void setRoot(Node root) {
        this.root = root;
    }

    public Tuple3d getCenterOfMassPosition() {
        Vector3d temp = new Vector3d((javax.vecmath.Tuple3d)this.temporaryCenterOfMassPosition);
        temp.scale(1.0 / this.getTotalMass());
        return ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)temp);
    }

    @Override
    public void visit(Node node) {
        PhysicalProperties physicalProperties;
        PhysicalBody physicalBodyNode;
        if (node instanceof PhysicalBody && (physicalBodyNode = (PhysicalBody)node).getPhysicalProperties() != null && (physicalProperties = physicalBodyNode.getPhysicalProperties()).getMass() != 0.0) {
            Matrix4d m = ApogyCommonTopologyFacade.INSTANCE.expressInFrame((Node)physicalBodyNode, this.getRoot());
            Point3d v = new Point3d();
            if (physicalProperties.getCenterOfMassLocation() != null) {
                v = new Point3d(physicalProperties.getCenterOfMassLocation().asTuple3d());
            }
            m.transform(v);
            v.scale(physicalProperties.getMass());
            this.temporaryCenterOfMassPosition.add((javax.vecmath.Tuple3d)v);
        }
        super.visit(node);
    }
}

