/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

abstract class RepositoryActionHandler
extends AbstractHandler {
    private IEvaluationContext evaluationContext;
    IStructuredSelection mySelection;

    RepositoryActionHandler() {
    }

    public void setSelection(ISelection selection) {
        this.mySelection = SelectionUtils.getStructuredSelection(selection);
    }

    protected IProject[] getProjectsForSelectedResources(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = RepositoryActionHandler.getSelection(event);
        return SelectionUtils.getSelectedProjects(selection);
    }

    protected IProject[] getProjectsForSelectedResources() {
        IStructuredSelection selection = this.getSelection();
        return SelectionUtils.getSelectedProjects(selection);
    }

    protected Repository[] getRepositoriesFor(IProject[] projects) {
        LinkedHashSet<Repository> ret = new LinkedHashSet<Repository>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IProject)project);
            if (repositoryMapping == null) {
                return new Repository[0];
            }
            ret.add(repositoryMapping.getRepository());
            ++n2;
        }
        return ret.toArray(new Repository[0]);
    }

    protected boolean haveSelectedResourcesWithRepository() {
        IResource[] resources;
        IStructuredSelection selection = this.getSelection();
        if (selection != null && (resources = SelectionUtils.getSelectedResources(selection)).length > 0) {
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource == null || RepositoryMapping.getMapping((IResource)resource) == null) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    protected Repository getRepository(boolean warn, ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = RepositoryActionHandler.getSelection(event);
        if (warn) {
            Shell shell = this.getShell(event);
            return SelectionUtils.getRepositoryOrWarn(selection, shell);
        }
        return SelectionUtils.getRepository(selection);
    }

    protected Repository getRepository() {
        IStructuredSelection selection = this.getSelection();
        return SelectionUtils.getRepository(selection);
    }

    protected Repository[] getRepositories(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = RepositoryActionHandler.getSelection(event);
        return SelectionUtils.getRepositories(selection);
    }

    public Repository[] getRepositories() {
        IStructuredSelection selection = this.getSelection();
        return SelectionUtils.getRepositories(selection);
    }

    protected static IStructuredSelection getSelection(ExecutionEvent event) throws ExecutionException {
        if (event == null) {
            throw new IllegalArgumentException("event must not be NULL");
        }
        Object context = event.getApplicationContext();
        if (context instanceof IEvaluationContext) {
            return SelectionUtils.getSelection((IEvaluationContext)context);
        }
        return StructuredSelection.EMPTY;
    }

    protected IStructuredSelection getSelection() {
        if (this.mySelection != null) {
            return this.mySelection;
        }
        return SelectionUtils.getSelection(this.evaluationContext);
    }

    public void setEnabled(Object evaluationContext) {
        this.evaluationContext = (IEvaluationContext)evaluationContext;
    }

    protected IResource[] getSelectedResources(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = RepositoryActionHandler.getSelection(event);
        return SelectionUtils.getSelectedResources(selection);
    }

    protected IPath[] getSelectedLocations(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = RepositoryActionHandler.getSelection(event);
        return SelectionUtils.getSelectedLocations(selection);
    }

    protected IResource[] getSelectedResources() {
        IStructuredSelection selection = this.getSelection();
        return SelectionUtils.getSelectedResources(selection);
    }

    protected IPath[] getSelectedLocations() {
        IStructuredSelection selection = this.getSelection();
        return SelectionUtils.getSelectedLocations(selection);
    }

    protected boolean selectionMapsToSingleRepository() {
        return this.getRepository() != null;
    }

    protected Shell getShell(ExecutionEvent event) throws ExecutionException {
        return HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
    }

    protected IWorkbenchPage getPartPage(ExecutionEvent event) throws ExecutionException {
        return this.getPart(event).getSite().getPage();
    }

    protected IWorkbenchPart getPart(ExecutionEvent event) throws ExecutionException {
        return HandlerUtil.getActivePartChecked((ExecutionEvent)event);
    }

    protected boolean containsHead(Repository repository) {
        try {
            return repository != null ? repository.resolve("HEAD") != null : false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isLocalBranchCheckedout(Repository repository) {
        try {
            String fullBranch = repository.getFullBranch();
            return fullBranch != null && fullBranch.startsWith("refs/heads/");
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected String getPreviousPath(Repository repository, ObjectReader reader, RevCommit headCommit, RevCommit previousCommit, String path) throws IOException {
        DiffEntry diffEntry = CompareCoreUtils.getChangeDiffEntry((Repository)repository, (String)path, (RevCommit)headCommit, (RevCommit)previousCommit, (ObjectReader)reader);
        if (diffEntry != null) {
            return diffEntry.getOldPath();
        }
        return path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RevCommit getHeadCommit(IResource resource) throws IOException {
        Repository repository = this.getRepository();
        if (resource == null) {
            return null;
        }
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource);
        if (mapping == null) {
            return null;
        }
        String path = mapping.getRepoRelativePath(resource);
        if (path == null) {
            return null;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            RevWalk rw = new RevWalk(repository);
            try {
                Ref head;
                rw.sort(RevSort.COMMIT_TIME_DESC, true);
                rw.sort(RevSort.BOUNDARY, true);
                if (path.length() > 0) {
                    DiffConfig diffConfig = (DiffConfig)repository.getConfig().get(DiffConfig.KEY);
                    FollowFilter filter = FollowFilter.create((String)path, (DiffConfig)diffConfig);
                    rw.setTreeFilter((TreeFilter)filter);
                }
                if ((head = repository.findRef("HEAD")) == null) {
                    return null;
                }
                RevCommit headCommit = rw.parseCommit((AnyObjectId)head.getObjectId());
                rw.close();
                return headCommit;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (rw == null) return null;
                rw.close();
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<RevCommit> findPreviousCommits(Collection<IResource> resources) throws IOException {
        ArrayList<RevCommit> result = new ArrayList<RevCommit>();
        Repository repository = this.getRepository();
        RepositoryMapping mapping = RepositoryMapping.getMapping((IProject)resources.iterator().next().getProject());
        if (mapping == null) {
            return result;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            RevWalk rw = new RevWalk(repository);
            try {
                block17: {
                    rw.sort(RevSort.COMMIT_TIME_DESC, true);
                    rw.sort(RevSort.BOUNDARY, true);
                    ArrayList<FollowFilter> filters = new ArrayList<FollowFilter>();
                    DiffConfig diffConfig = (DiffConfig)repository.getConfig().get(DiffConfig.KEY);
                    Iterator<IResource> iterator = resources.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            if (filters.size() < 2) break;
                            TreeFilter filter = OrTreeFilter.create(filters);
                            rw.setTreeFilter(filter);
                            break block17;
                        }
                        IResource resource = iterator.next();
                        String path = mapping.getRepoRelativePath(resource);
                        if (path == null || path.length() <= 0) continue;
                        filters.add(FollowFilter.create((String)path, (DiffConfig)diffConfig));
                    }
                    if (filters.size() == 1) {
                        rw.setTreeFilter((TreeFilter)filters.get(0));
                    }
                }
                Ref head = repository.findRef("HEAD");
                if (head == null) {
                    return result;
                }
                RevCommit headCommit = rw.parseCommit((AnyObjectId)head.getObjectId());
                rw.markStart(headCommit);
                headCommit = rw.next();
                if (headCommit == null) {
                    return result;
                }
                List<RevCommit> directParents = Arrays.asList(headCommit.getParents());
                RevCommit previousCommit = rw.next();
                while (true) {
                    if (previousCommit == null || result.size() >= directParents.size()) {
                        rw.dispose();
                        return result;
                    }
                    if (directParents.contains(previousCommit)) {
                        result.add(previousCommit);
                    }
                    previousCommit = rw.next();
                }
            }
            finally {
                if (rw == null) return result;
                rw.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    public boolean isEnabled() {
        return this.getProjectsForSelectedResources().length > 0;
    }

    protected boolean alwaysCheckEnabled() {
        return false;
    }

    protected static final class PreviousCommit {
        final RevCommit commit;
        final String path;

        PreviousCommit(RevCommit commit, String path) {
            this.commit = commit;
            this.path = path;
        }
    }
}

