/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.impl;

import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.ui.scene_objects.CartesianTriangularMeshSceneObject;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.apogy.core.environment.surface.CartesianTriangularMeshMapLayerNode;
import org.eclipse.apogy.core.environment.surface.ui.Activator;
import org.eclipse.apogy.core.environment.surface.ui.impl.CartesianTriangularMeshMapLayerNodePresentationImpl;
import org.eclipse.apogy.core.environment.surface.ui.scene_objects.CartesianTriangularMeshMapLayerNodeSceneObject;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class CartesianTriangularMeshMapLayerNodePresentationCustomImpl
extends CartesianTriangularMeshMapLayerNodePresentationImpl {
    protected CartesianTriangularMeshMapLayerNodePresentationCustomImpl() {
        this.applyPreferences();
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.getPreferencesListener());
    }

    public CartesianTriangularMesh basicGetMesh() {
        CartesianTriangularMesh mesh = null;
        if (this.getNode() != null) {
            CartesianTriangularMeshMapLayerNode cNode = (CartesianTriangularMeshMapLayerNode)this.getNode();
            return cNode.getCartesianTriangularMeshMapLayer().getCurrentMesh();
        }
        return mesh;
    }

    public boolean isSetMesh() {
        return this.getNode() != null;
    }

    protected void updateSceneObject(Notification notification) {
        if (this.sceneObject != null) {
            CartesianTriangularMeshMapLayerNodeSceneObject meshSceneObject = (CartesianTriangularMeshMapLayerNodeSceneObject)this.sceneObject;
            if (notification.getNotifier() instanceof CartesianTriangularMeshMapLayerNodePresentationCustomImpl) {
                int featureID = notification.getFeatureID(CartesianTriangularMeshMapLayerNodePresentationCustomImpl.class);
                switch (featureID) {
                    case 18: {
                        int newPointSizeValue = notification.getNewIntValue();
                        meshSceneObject.setPointSize(newPointSizeValue);
                        break;
                    }
                    case 21: {
                        MeshPresentationMode newMode = (MeshPresentationMode)notification.getNewValue();
                        meshSceneObject.setPresentationMode(newMode);
                        break;
                    }
                    case 22: {
                        meshSceneObject.setTransparency(notification.getNewFloatValue());
                        break;
                    }
                    case 23: {
                        meshSceneObject.setUseShading(notification.getNewBooleanValue());
                        break;
                    }
                }
            }
        }
        super.updateSceneObject(notification);
    }

    protected void initialSceneObject() {
        CartesianTriangularMeshSceneObject meshSceneObject = (CartesianTriangularMeshSceneObject)this.sceneObject;
        meshSceneObject.setPointSize(this.getPointSize());
        meshSceneObject.setPresentationMode(this.getPresentationMode());
        meshSceneObject.setTransparency(this.getTransparency());
        super.initialSceneObject();
    }

    public Tuple3d basicGetCentroid() {
        Tuple3d centroid = ApogyCommonMathFacade.INSTANCE.createTuple3d(0.0, 0.0, 0.0);
        if (this.getSceneObject() != null) {
            centroid = ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)this.getSceneObject().getCentroid());
        }
        return centroid;
    }

    public boolean isEnableTextureProjection() {
        return true;
    }

    protected IPropertyChangeListener getPreferencesListener() {
        if (this.preferencesListener == null) {
            this.preferencesListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    CartesianTriangularMeshMapLayerNodePresentationCustomImpl.this.applyPreferences();
                }
            };
        }
        return this.preferencesListener;
    }
}

