/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.impl;

import javax.vecmath.Point3f;
import org.eclipse.apogy.core.environment.Star;
import org.eclipse.apogy.core.environment.surface.ui.impl.EnvironmentSurfaceUIUtilitiesImpl;

public class EnvironmentSurfaceUIUtilitiesCustomImpl
extends EnvironmentSurfaceUIUtilitiesImpl {
    public static final float POGSON_RATIO = (float)Math.pow(100.0, 0.2);

    @Override
    public Point3f toPoint3f(Star star) {
        float r = 1.0f;
        float x = r * (float)(Math.cos(star.getEquatorialCoordinates().getDeclination()) * Math.cos(star.getEquatorialCoordinates().getRightAscension()));
        float y = r * (float)(Math.cos(star.getEquatorialCoordinates().getDeclination()) * Math.sin(star.getEquatorialCoordinates().getRightAscension()));
        float z = r * (float)Math.sin(star.getEquatorialCoordinates().getDeclination());
        Point3f p = new Point3f(x, y, z);
        return p;
    }

    @Override
    public float getPointSizeForMagnitude(float magnitude, float magnitudeRangeMinimum, float magnitudeRangeMaximum, float minimumPointSize, float maximumPointSize) {
        float radiusRange = (float)Math.sqrt(Math.pow(POGSON_RATIO, magnitudeRangeMaximum - magnitudeRangeMinimum));
        float luminosity = (float)Math.pow(POGSON_RATIO, magnitudeRangeMaximum - magnitude);
        float radius = (float)(Math.sqrt(luminosity) / (double)radiusRange * (double)(maximumPointSize - minimumPointSize) + (double)minimumPointSize);
        return radius;
    }
}

