/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EarthViewPointNavigationType implements Enumerator
{
    ORBIT_VIEW(0, "ORBIT_VIEW", "ORBIT_VIEW"),
    FLY_VIEW(1, "FLY_VIEW", "FLY_VIEW");

    public static final int ORBIT_VIEW_VALUE = 0;
    public static final int FLY_VIEW_VALUE = 1;
    private static final EarthViewPointNavigationType[] VALUES_ARRAY;
    public static final List<EarthViewPointNavigationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EarthViewPointNavigationType[]{ORBIT_VIEW, FLY_VIEW};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EarthViewPointNavigationType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EarthViewPointNavigationType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EarthViewPointNavigationType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EarthViewPointNavigationType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EarthViewPointNavigationType get(int value) {
        switch (value) {
            case 0: {
                return ORBIT_VIEW;
            }
            case 1: {
                return FLY_VIEW;
            }
        }
        return null;
    }

    private EarthViewPointNavigationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

