/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.impl;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.environment.earth.ui.ApogyEarthEnvironmentUIPackage;
import org.eclipse.apogy.core.environment.earth.ui.impl.AbstractWorldWindLayerImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorldWindLayerCustomImpl
extends AbstractWorldWindLayerImpl {
    public static final long MAXIMUM_DISPOSE_WAIT_TIME_MS = 100L;
    private static final Logger Logger = LoggerFactory.getLogger(AbstractWorldWindLayerImpl.class);
    private static UIJob blinkingJob = null;
    private static Map<AbstractWorldWindLayerCustomImpl, Boolean> blinkingLayers = new HashMap<AbstractWorldWindLayerCustomImpl, Boolean>();

    protected AbstractWorldWindLayerCustomImpl() {
        AbstractWorldWindLayerCustomImpl.getBlinkingJob();
    }

    @Override
    public void setVisible(boolean newVisible) {
        super.setVisible(newVisible);
        if (this.getName() != null) {
            Logger.info(String.valueOf(this.getName()) + " : Setting visibility to <" + newVisible + ">.");
        } else {
            Logger.info("Setting visibility to <" + newVisible + ">.");
        }
        try {
            this.update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setBlinking(boolean newBlinking) {
        if (newBlinking && !this.blinking) {
            blinkingLayers.put(this, this.isVisible());
        } else if (!newBlinking && this.blinking) {
            Boolean originalVisibility = blinkingLayers.get(this);
            if (originalVisibility != null) {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.ABSTRACT_WORLD_WIND_LAYER__VISIBLE, (Object)originalVisibility, true);
            }
            blinkingLayers.remove(this);
        }
        super.setBlinking(newBlinking);
    }

    @Override
    public RenderableLayer getRenderableLayer() {
        RenderableLayer tmp = super.getRenderableLayer();
        if (tmp == null) {
            tmp = this.renderableLayer = new RenderableLayer();
        }
        return tmp;
    }

    @Override
    public void initialise() {
    }

    public void update() throws Exception {
        if (!this.isUpdating() && !this.isDisposed()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (AbstractWorldWindLayerCustomImpl.this.getWorldWindow() != null) {
                        try {
                            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)AbstractWorldWindLayerCustomImpl.this, (EStructuralFeature)ApogyCorePackage.Literals.UPDATABLE__UPDATING, (Object)true, true);
                            AbstractWorldWindLayerCustomImpl.this.getWorldWindow().getModel().getLayers().remove((Layer)AbstractWorldWindLayerCustomImpl.this.getRenderableLayer());
                            AbstractWorldWindLayerCustomImpl.this.updateRenderableLayer();
                            AbstractWorldWindLayerCustomImpl.this.getWorldWindow().getModel().getLayers().add((Layer)AbstractWorldWindLayerCustomImpl.this.getRenderableLayer());
                            AbstractWorldWindLayerCustomImpl.this.getWorldWindow().redrawNow();
                            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)AbstractWorldWindLayerCustomImpl.this, (EStructuralFeature)ApogyCorePackage.Literals.UPDATABLE__UPDATING, (Object)false, true);
                        }
                        catch (Exception e) {
                            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)AbstractWorldWindLayerCustomImpl.this, (EStructuralFeature)ApogyCorePackage.Literals.UPDATABLE__UPDATING, (Object)false, true);
                            Logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void dispose() {
        if (this.getName() != null) {
            Logger.info("Layer <" + this.getName() + "> disposing...");
        } else {
            Logger.info("Layer of type <" + this.getClass().getSimpleName() + "> disposing...");
        }
        long waitTime = 0L;
        while (this.isUpdating() && waitTime < 100L) {
            try {
                Logger.warn("Waiting for layer to complete update...");
                Thread.sleep(200L);
                waitTime += 200L;
            }
            catch (Exception exception) {}
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.ABSTRACT_WORLD_WIND_LAYER__DISPOSED, (Object)true, true);
        try {
            UIJob job = new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor arg0) {
                    RenderableLayer layer = AbstractWorldWindLayerCustomImpl.this.getRenderableLayer();
                    layer.removeAllRenderables();
                    AbstractWorldWindLayerCustomImpl.this.getRenderableLayer().firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, (Object)this);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getDefaultAutoUpdateEnabled() {
        return false;
    }

    protected abstract void updateRenderableLayer();

    private static UIJob getBlinkingJob() {
        if (blinkingJob == null) {
            blinkingJob = new UIJob("World Wind Layer Blinking"){
                private boolean visible = true;

                public IStatus runInUIThread(IProgressMonitor progressMonitor) {
                    ArrayList layers = new ArrayList(blinkingLayers.keySet());
                    for (AbstractWorldWindLayerCustomImpl layer : layers) {
                        if (layer.isDisposed()) continue;
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)layer, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.ABSTRACT_WORLD_WIND_LAYER__VISIBLE, (Object)this.visible, true);
                    }
                    boolean bl = this.visible = !this.visible;
                    if (!progressMonitor.isCanceled()) {
                        this.schedule(1000L);
                    }
                    return Status.OK_STATUS;
                }
            };
            blinkingJob.setPriority(30);
            blinkingJob.schedule();
        }
        return blinkingJob;
    }
}

