/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.impl;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.layers.Layer;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.earth.ui.AbstractWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.ui.ApogyEarthEnvironmentUIPackage;
import org.eclipse.apogy.core.environment.earth.ui.CompositeWorldWindLayer;
import org.eclipse.apogy.core.environment.earth.ui.impl.CompositeWorldWindLayerImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeWorldWindLayerCustomImpl
extends CompositeWorldWindLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(CompositeWorldWindLayerCustomImpl.class);
    private Adapter layersAdapter;

    @Override
    public void initialise() {
        super.initialise();
        this.eAdapters().add((Object)this.getLayersAdapter());
        for (AbstractWorldWindLayer layer : this.getLayers()) {
            try {
                layer.initialise();
            }
            catch (Exception e) {
                Logger.error("Sub-layer <" + layer.getName() + "> initialise failed.", (Throwable)e);
            }
        }
    }

    @Override
    public void update() throws Exception {
        for (AbstractWorldWindLayer layer : this.getLayers()) {
            try {
                layer.update();
            }
            catch (Exception e) {
                Logger.error("Sub-layer <" + layer.getName() + "> update failed.", (Throwable)e);
            }
        }
    }

    @Override
    public void dispose() {
        this.eAdapters().remove((Object)this.getLayersAdapter());
        for (AbstractWorldWindLayer layer : this.getLayers()) {
            try {
                layer.dispose();
            }
            catch (Exception e) {
                Logger.error("Sub-layer <" + layer.getName() + "> dispose failed.", (Throwable)e);
            }
        }
        super.dispose();
    }

    @Override
    public void setVisible(boolean newVisible) {
        super.setVisible(newVisible);
        for (AbstractWorldWindLayer layer : this.getLayers()) {
            try {
                layer.setVisible(newVisible);
            }
            catch (Exception e) {
                Logger.error("Sub-layer <" + layer.getName() + "> setVisible(" + newVisible + ") failed.", (Throwable)e);
            }
        }
    }

    @Override
    protected void updateRenderableLayer() {
    }

    @Override
    public void setWorldWindow(WorldWindow newWorldWindow) {
        super.setWorldWindow(newWorldWindow);
        for (AbstractWorldWindLayer layer : this.getLayers()) {
            try {
                layer.setWorldWindow(newWorldWindow);
                newWorldWindow.getModel().getLayers().add((Layer)layer.getRenderableLayer());
                layer.update();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void addLayer(AbstractWorldWindLayer abstractWorldWindLayer) {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)abstractWorldWindLayer, (EStructuralFeature)ApogyEarthEnvironmentUIPackage.Literals.ABSTRACT_WORLD_WIND_LAYER__WORLD_WINDOW, (Object)this.getWorldWindow(), true);
        abstractWorldWindLayer.initialise();
        if (abstractWorldWindLayer.getRenderableLayer() != null && this.getWorldWindow() != null) {
            this.getWorldWindow().getModel().getLayers().add((Layer)abstractWorldWindLayer.getRenderableLayer());
            this.getWorldWindow().redraw();
        }
        this.layers.add((Object)abstractWorldWindLayer);
    }

    protected void removeLayer(AbstractWorldWindLayer abstractWorldWindLayer) {
        if (abstractWorldWindLayer.getRenderableLayer() != null && this.getWorldWindow() != null) {
            this.getWorldWindow().getModel().getLayers().remove((Layer)abstractWorldWindLayer.getRenderableLayer());
        }
        try {
            abstractWorldWindLayer.dispose();
        }
        catch (Exception e) {
            Logger.error("Failed to dispose of layer <" + abstractWorldWindLayer + ">", (Throwable)e);
        }
    }

    private Adapter getLayersAdapter() {
        this.layersAdapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                block17: {
                    if (!(msg.getNotifier() instanceof CompositeWorldWindLayer)) break block17;
                    int featureID = msg.getFeatureID(CompositeWorldWindLayer.class);
                    block2 : switch (featureID) {
                        case 10: {
                            int eventType = msg.getEventType();
                            switch (eventType) {
                                case 3: {
                                    if (msg.getNewValue() instanceof AbstractWorldWindLayer) {
                                        CompositeWorldWindLayerCustomImpl.this.addLayer((AbstractWorldWindLayer)msg.getNewValue());
                                        break block2;
                                    }
                                    break block17;
                                }
                                case 5: {
                                    try {
                                        List layers = (List)msg.getNewValue();
                                        for (AbstractWorldWindLayer layer : layers) {
                                            CompositeWorldWindLayerCustomImpl.this.addLayer(layer);
                                        }
                                        break block17;
                                    }
                                    catch (Throwable t) {
                                        Logger.error(t.getMessage(), t);
                                    }
                                    break block17;
                                }
                                case 4: {
                                    if (msg.getOldValue() instanceof AbstractWorldWindLayer) {
                                        CompositeWorldWindLayerCustomImpl.this.removeLayer((AbstractWorldWindLayer)msg.getOldValue());
                                        break block2;
                                    }
                                    break block17;
                                }
                                case 6: {
                                    try {
                                        List layers = (List)msg.getOldValue();
                                        for (AbstractWorldWindLayer layer : layers) {
                                            CompositeWorldWindLayerCustomImpl.this.removeLayer(layer);
                                        }
                                    }
                                    catch (Throwable t) {
                                        Logger.error(t.getMessage(), t);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        };
        return this.layersAdapter;
    }
}

