/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.impl;

import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.core.environment.earth.ApogyCoreEnvironmentEarthFacade;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.ui.impl.DateChangeLineWorldWindLayerImpl;
import org.eclipse.apogy.core.environment.earth.ui.utils.WorldWindUtils;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateChangeLineWorldWindLayerCustomImpl
extends DateChangeLineWorldWindLayerImpl {
    public static final String DATE_LINE_FILE_URL = "platform:/plugin/org.eclipse.apogy.core.environment.earth.ui/data/date_change_line.csv";
    public static final short GROUND_TRACE_STIPPLE_PATTERN = 255;
    public static final int GROUND_TRACE_STIPPLE_FACTOR = 1;
    private static final Logger Logger = LoggerFactory.getLogger(DateChangeLineWorldWindLayerCustomImpl.class);

    @Override
    public void setColor(RGBA newColor) {
        super.setColor(newColor);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error("Error ocurred while updating the color. ", (Throwable)e);
            }
        }
    }

    @Override
    protected void updateRenderableLayer() {
        RenderableLayer layer = this.getRenderableLayer();
        layer.removeAllRenderables();
        if (this.isVisible()) {
            try {
                List<GeographicCoordinates> coordinates = this.readGeographicCoordinates();
                List<Polyline> polylines = WorldWindUtils.createPolyLineFromGeographicCoordinatesListNoWrapAround(coordinates);
                Color color = WorldWindUtils.convertFrom(this.getColor());
                for (Polyline line : polylines) {
                    Polyline groundTrace = new Polyline(line.getPositions());
                    groundTrace.setFollowTerrain(true);
                    groundTrace.setColor(color);
                    groundTrace.setStippleFactor(1);
                    groundTrace.setStipplePattern((short)255);
                    layer.addRenderable((Renderable)groundTrace);
                }
            }
            catch (Exception e) {
                Logger.error("Error occured during updateRenderableLayer.", (Throwable)e);
            }
        }
    }

    private List<GeographicCoordinates> readGeographicCoordinates() {
        ArrayList<GeographicCoordinates> coordinates = new ArrayList();
        try {
            coordinates = ApogyCoreEnvironmentEarthFacade.INSTANCE.loadGeographicCoordinatesFromURL(DATE_LINE_FILE_URL);
        }
        catch (Exception ex) {
            Logger.error("Could not open file.", (Throwable)ex);
        }
        return coordinates;
    }
}

