/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.impl;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceCircle;
import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.ui.impl.GeographicCoordinatesWorldWindLayerImpl;
import org.eclipse.apogy.core.environment.earth.ui.utils.MultiEObjectsAdapter;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeographicCoordinatesWorldWindLayerCustomImpl
extends GeographicCoordinatesWorldWindLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(GeographicCoordinatesWorldWindLayerImpl.class);
    public static final String DEGREE_STRING = "\u00b0";
    private MultiEObjectsAdapter geographicCoordinatesAdapter = null;
    private boolean busy = false;
    private DecimalFormat latLongFormat = new DecimalFormat("0.000");
    private DecimalFormat altitudeFormat = new DecimalFormat("0.0");

    protected GeographicCoordinatesWorldWindLayerCustomImpl() {
    }

    @Override
    public void initialise() {
        super.initialise();
        this.eAdapters().add((Object)this.getGeographicCoordinatesAdapter());
    }

    @Override
    public void dispose() {
        this.eAdapters().remove((Object)this.getGeographicCoordinatesAdapter());
        super.dispose();
    }

    @Override
    public void setDisplayedRadius(double newDisplayedRadius) {
        super.setDisplayedRadius(newDisplayedRadius);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    protected void updateRenderableLayer() {
        RenderableLayer layer = this.getRenderableLayer();
        layer.removeAllRenderables();
        if (this.isVisible()) {
            try {
                this.addRenderable(layer);
            }
            catch (Exception e) {
                Logger.error("Error occured during updateRenderableLayer().", (Throwable)e);
            }
        }
    }

    @Override
    public void selectionChanged(final List<EObject> items) {
        if (!(this.isLockSelection() || this.isUpdating() || this.busy)) {
            this.busy = true;
            TransactionalEditingDomain transactionalEditingDomain = ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this);
            RecordingCommand cmd = new RecordingCommand(transactionalEditingDomain){

                protected void doExecute() {
                    try {
                        GeographicCoordinatesWorldWindLayerCustomImpl.this.setUpdating(true);
                        ArrayList<GeographicCoordinates> coordinates = new ArrayList<GeographicCoordinates>();
                        for (EObject eObject : items) {
                            if (!(eObject instanceof GeographicCoordinates)) continue;
                            coordinates.add((GeographicCoordinates)eObject);
                        }
                        Logger.info("Selected <" + coordinates.size() + "> Geographic Coordinate(s).");
                        if (coordinates.size() > 0 || GeographicCoordinatesWorldWindLayerCustomImpl.this.isAllowZeroSizeSelection()) {
                            GeographicCoordinatesWorldWindLayerCustomImpl.this.getGeographicCoordinatesList().clear();
                            GeographicCoordinatesWorldWindLayerCustomImpl.this.getGeographicCoordinatesAdapter().unregisterFromAllObjects();
                            for (GeographicCoordinates geographicCoordinates : coordinates) {
                                GeographicCoordinatesWorldWindLayerCustomImpl.this.getGeographicCoordinatesAdapter().registerToEObject((EObject)geographicCoordinates);
                                GeographicCoordinatesWorldWindLayerCustomImpl.this.getGeographicCoordinatesList().add((Object)geographicCoordinates);
                            }
                            GeographicCoordinatesWorldWindLayerCustomImpl.this.updateRenderableLayer();
                        }
                    }
                    catch (Exception e) {
                        Logger.error("Selection changed failed !", (Throwable)e);
                    }
                    GeographicCoordinatesWorldWindLayerCustomImpl.this.setUpdating(false);
                    GeographicCoordinatesWorldWindLayerCustomImpl.this.busy = false;
                }
            };
            try {
                transactionalEditingDomain.getCommandStack().execute((Command)cmd);
            }
            catch (Throwable throwable) {}
        }
    }

    protected void addRenderable(RenderableLayer layer) {
        try {
            if (!this.getGeographicCoordinatesList().isEmpty()) {
                for (GeographicCoordinates coord : this.getGeographicCoordinatesList()) {
                    Angle latitude = Angle.fromRadiansLatitude((double)coord.getLatitude());
                    Angle longitude = Angle.fromRadiansLongitude((double)coord.getLongitude());
                    double elevation = coord.getElevation();
                    Position position = new Position(latitude, longitude, elevation);
                    BasicShapeAttributes attributes = new BasicShapeAttributes();
                    attributes.setDrawInterior(true);
                    Material mat = new Material(Color.CYAN);
                    attributes.setInteriorMaterial(mat);
                    SurfaceCircle surfaceCircle = new SurfaceCircle((ShapeAttributes)attributes, (LatLon)position, this.getDisplayedRadius() * 1000.0, 24);
                    surfaceCircle.setVisible(true);
                    layer.addRenderable((Renderable)surfaceCircle);
                    String text = this.getDisplayedText(coord);
                    if (text == null) continue;
                    GlobeAnnotation annotation = new GlobeAnnotation(text, position);
                    AnnotationAttributes annotationAttributes = new AnnotationAttributes();
                    annotationAttributes.setCornerRadius(0);
                    annotationAttributes.setVisible(true);
                    Font font = annotationAttributes.getFont();
                    font = font.deriveFont(1, 16.0f);
                    annotationAttributes.setFont(font);
                    Color transparent = new Color(0.0f, 0.0f, 1.0f, 0.3f);
                    annotationAttributes.setBackgroundColor(transparent);
                    annotationAttributes.setTextColor(Color.YELLOW);
                    annotation.setAttributes(annotationAttributes);
                    layer.addRenderable((Renderable)annotation);
                }
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    protected String getDisplayedText(GeographicCoordinates coord) {
        ENamedElement named;
        String name;
        String text = null;
        if (coord instanceof ENamedElement && (name = (named = (ENamedElement)coord).getName()) != null && name.length() > 0) {
            text = name;
        }
        if (this.isDisplayLocation()) {
            text = text == null ? new String() : String.valueOf(text) + "\n";
            text = String.valueOf(text) + this.latLongFormat.format(Math.toDegrees(coord.getLatitude())) + DEGREE_STRING + " lat, ";
            text = String.valueOf(text) + this.latLongFormat.format(Math.toDegrees(coord.getLongitude())) + DEGREE_STRING + " lon, ";
            text = String.valueOf(text) + this.altitudeFormat.format(coord.getElevation()) + " m alt";
        }
        return text;
    }

    protected MultiEObjectsAdapter getGeographicCoordinatesAdapter() {
        if (this.geographicCoordinatesAdapter == null) {
            this.geographicCoordinatesAdapter = new MultiEObjectsAdapter(){

                @Override
                public void registerToEObject(EObject eObject) {
                    if (eObject instanceof GeographicCoordinates) {
                        GeographicCoordinates newGeographicCoordinates = (GeographicCoordinates)eObject;
                        newGeographicCoordinates.eAdapters().add((Object)GeographicCoordinatesWorldWindLayerCustomImpl.this.getGeographicCoordinatesAdapter());
                    } else {
                        super.registerToEObject(eObject);
                    }
                }

                public void notifyChanged(Notification msg) {
                    int featureId;
                    block13: {
                        block12: {
                            if (!(msg.getNotifier() instanceof GeographicCoordinates)) break block12;
                            featureId = msg.getFeatureID(GeographicCoordinates.class);
                            switch (featureId) {
                                case 0: 
                                case 1: 
                                case 2: {
                                    if (GeographicCoordinatesWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                                        GeographicCoordinatesWorldWindLayerCustomImpl.this.updateRenderableLayer();
                                        break;
                                    } else {
                                        break;
                                    }
                                }
                            }
                            break block13;
                        }
                        if (msg.getNotifier() instanceof GeographicCoordinatesWorldWindLayerCustomImpl) {
                            featureId = msg.getFeatureID(GeographicCoordinatesWorldWindLayerCustomImpl.class);
                            switch (featureId) {
                                case 12: 
                                case 13: 
                                case 14: {
                                    if (!GeographicCoordinatesWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) break;
                                    GeographicCoordinatesWorldWindLayerCustomImpl.this.updateRenderableLayer();
                                    break;
                                }
                            }
                        }
                    }
                    if (msg.getNotifier() instanceof Named) {
                        featureId = msg.getFeatureID(Named.class);
                        switch (featureId) {
                            case 1: {
                                if (!GeographicCoordinatesWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) break;
                                GeographicCoordinatesWorldWindLayerCustomImpl.this.updateRenderableLayer();
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.geographicCoordinatesAdapter;
    }
}

