/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.impl;

import org.eclipse.apogy.core.environment.surface.ShaderBasedMeshToolType;
import org.eclipse.apogy.core.environment.surface.SlopeRange;
import org.eclipse.apogy.core.environment.surface.impl.ShaderBasedDiscreteSlopesToolImpl;

public class ShaderBasedDiscreteSlopesToolCustomImpl
extends ShaderBasedDiscreteSlopesToolImpl {
    public static final int TOOL_SLOPE_RANGE_LOWER_SLOPE_INDEX = 0;
    public static final int TOOL_SLOPE_RANGE_UPPER_SLOPE_INDEX = 1;
    public static final int TOOL_SLOPE_RANGE_COLOR_RED_INDEX = 2;
    public static final int TOOL_SLOPE_RANGE_COLOR_GREEN_INDEX = 3;
    public static final int TOOL_SLOPE_RANGE_COLOR_BLUE_INDEX = 4;
    public static final int TOOL_SLOPE_RANGE_SIZE = 5;

    @Override
    public ShaderBasedMeshToolType getToolType() {
        return ShaderBasedMeshToolType.DISCRETE_SLOPES;
    }

    @Override
    public float[] createShaderParameters() {
        float[] parameters = super.createShaderParameters();
        int rangeIndex = 3;
        int i = 0;
        while (i < 3) {
            parameters[rangeIndex + 0] = -1.0f;
            parameters[rangeIndex + 1] = -1.0f;
            parameters[rangeIndex + 2] = 0.0f;
            parameters[rangeIndex + 3] = 0.0f;
            parameters[rangeIndex + 4] = 0.0f;
            ++i;
        }
        rangeIndex = 3;
        for (SlopeRange slopeRange : this.getSlopeRanges()) {
            parameters[rangeIndex + 0] = new Float(Math.toRadians(slopeRange.getSlopeLowerBound())).floatValue();
            parameters[rangeIndex + 1] = new Float(Math.toRadians(slopeRange.getSlopeUpperBound())).floatValue();
            parameters[rangeIndex + 2] = new Float((float)slopeRange.getColor().rgb.red / 255.0f).floatValue();
            parameters[rangeIndex + 3] = new Float((float)slopeRange.getColor().rgb.green / 255.0f).floatValue();
            parameters[rangeIndex + 4] = new Float((float)slopeRange.getColor().rgb.blue / 255.0f).floatValue();
            rangeIndex += 5;
        }
        return parameters;
    }
}

