/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.impl;

import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFactory;
import org.eclipse.apogy.common.math.Matrix3x3;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.ShaderBasedMeshToolType;
import org.eclipse.apogy.core.environment.surface.impl.ShaderBasedGridToolImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ShaderBasedGridToolCustomImpl
extends ShaderBasedGridToolImpl {
    public static final int TOOL_GRID_COLOR_RED_INDEX = 3;
    public static final int TOOL_GRID_COLOR_GREEN_INDEX = 4;
    public static final int TOOL_GRID_COLOR_BLUE_INDEX = 5;
    public static final int TOOL_GRID_SHOW_X_INDEX = 6;
    public static final int TOOL_GRID_DELTA_X_INDEX = 7;
    public static final int TOOL_GRID_MIN_X_INDEX = 8;
    public static final int TOOL_GRID_MAX_X_INDEX = 9;
    public static final int TOOL_GRID_SHOW_Y_INDEX = 10;
    public static final int TOOL_GRID_DELTA_Y_INDEX = 11;
    public static final int TOOL_GRID_MIN_Y_INDEX = 12;
    public static final int TOOL_GRID_MAX_Y_INDEX = 13;
    public static final int TOOL_GRID_LINE_WIDTH_INDEX = 14;

    @Override
    public ShaderBasedMeshToolType getToolType() {
        return ShaderBasedMeshToolType.GRID;
    }

    @Override
    public void setXGridSpacing(float newXGridSpacing) {
        super.setXGridSpacing(Math.abs(newXGridSpacing));
    }

    @Override
    public void setYGridSpacing(float newYGridSpacing) {
        super.setYGridSpacing(Math.abs(newYGridSpacing));
    }

    @Override
    public Tuple3d getPosition() {
        Tuple3d position = super.getPosition();
        if (position == null) {
            position = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.SHADER_BASED_MESH_TOOL__POSITION, (Object)position, true);
        }
        return position;
    }

    @Override
    public Matrix3x3 getRotationMatrix() {
        Matrix3x3 rotation = super.getRotationMatrix();
        if (rotation == null) {
            rotation = ApogyCommonMathFacade.INSTANCE.createIdentityMatrix3x3();
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.SHADER_BASED_MESH_TOOL__ROTATION_MATRIX, (Object)rotation, true);
        }
        return rotation;
    }

    @Override
    public float[] createShaderParameters() {
        float[] parameters = super.createShaderParameters();
        parameters[3] = new Float((float)this.getLineColor().rgb.red / 255.0f).floatValue();
        parameters[4] = new Float((float)this.getLineColor().rgb.green / 255.0f).floatValue();
        parameters[5] = new Float((float)this.getLineColor().rgb.blue / 255.0f).floatValue();
        parameters[6] = this.isShowXLines() ? 1.0f : 0.0f;
        parameters[7] = Math.abs(this.getXGridSpacing());
        parameters[8] = this.getMinX();
        parameters[9] = this.getMaxX();
        parameters[10] = this.isShowYLines() ? 1.0f : 0.0f;
        parameters[11] = Math.abs(this.getYGridSpacing());
        parameters[12] = this.getMinY();
        parameters[13] = this.getMaxY();
        parameters[14] = Math.abs(this.getGridLineWidth());
        return parameters;
    }
}

