/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.math.ui.composites;

import java.util.Collection;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tuple3dListComposite<RootEObject extends EObject, ResolvedEObject extends EObject, ItemEObject extends Tuple3d>
extends EMFFormsEListComposite<RootEObject, ResolvedEObject, ItemEObject> {
    public static String path = System.getProperty("user.home");
    private static final Logger Logger = LoggerFactory.getLogger(Tuple3dListComposite.class);

    public Tuple3dListComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        super(parent, style, featurePath, eStructuralFeature);
    }

    public Tuple3dListComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    protected void createButtons(Composite parent, int style) {
        this.createNewButton(parent, style);
        this.createDeleteButton(parent, style);
        this.createSeparator(parent, style);
        this.createUpButton(parent, style);
        this.createDownButton(parent, style);
        this.createSeparator(parent, style);
        this.createImportButton(parent, style);
    }

    protected void createImportButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> true);
    }

    protected void doImport() {
        FileDialog fd = new FileDialog(this.getShell(), 4096);
        fd.setFilterPath(path);
        fd.setFilterExtensions(new String[]{"*.csv"});
        fd.setOverwrite(true);
        String filePath = fd.open();
        if (filePath != null) {
            String urlString = "file://localhost/" + filePath.replace("\\", "/");
            try {
                List foiList = ApogyCommonMathFacade.INSTANCE.loadTuple3dFromFile(urlString);
                ApogyCommonTransactionFacade.INSTANCE.basicAdd(this.getRootEObject(), this.getEStructuralFeature(), (Collection)foiList, true);
                if (foiList.size() > 0) {
                    Logger.info("Loaded <" + foiList.size() + "> Tuple3d from file<" + urlString + ">.");
                } else {
                    Logger.error("Could not load any Tuple3d from file<" + urlString + ">.");
                }
            }
            catch (Exception ex) {
                Logger.error("Failed to import Tuple3d from file<" + urlString + ">.", (Throwable)ex);
            }
        }
    }
}

