/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.bindings.ui.dialogs;

import org.eclipse.apogy.common.emf.AbstractFeatureNode;
import org.eclipse.apogy.common.emf.AbstractFeatureSpecifier;
import org.eclipse.apogy.common.emf.AbstractFeatureTreeNode;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.topology.bindings.FeatureRootsList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class AbstractFeatureNodeSelectionDialog
extends Dialog {
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private FeatureRootsList featureRootsList;
    private AbstractFeatureNode selectedAbstractFeatureNode;
    private Class featureSuperClass = null;
    private Tree tree;
    private TreeViewer treeViewer;
    private Text txtSelectedAbstractFeatureTreeNode;

    public AbstractFeatureNodeSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    public AbstractFeatureNodeSelectionDialog(Shell parentShell, FeatureRootsList featureRootsList, Class featureSuperClass) {
        super(parentShell);
        this.featureRootsList = featureRootsList;
        this.featureSuperClass = featureSuperClass;
    }

    public AbstractFeatureNode getSelectedAbstractFeatureNode() {
        return this.selectedAbstractFeatureNode;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Feature Selection dialog");
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            this.setSelectedAbstractFeatureNode(null);
        } else if (!(this.selectedAbstractFeatureNode instanceof AbstractFeatureSpecifier)) {
            this.setSelectedAbstractFeatureNode(null);
        }
        super.buttonPressed(buttonId);
    }

    protected Point getInitialSize() {
        return new Point(450, 450);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite top = new Composite(container, 0);
        top.setLayout((Layout)new GridLayout(2, false));
        GridData gd_top = new GridData(4, 4, true, true);
        top.setLayoutData((Object)gd_top);
        Label lblSelectedAbstractFeatureTreeNode = new Label(top, 0);
        lblSelectedAbstractFeatureTreeNode.setText("Selected Feature Node : ");
        this.txtSelectedAbstractFeatureTreeNode = new Text(top, 0);
        this.txtSelectedAbstractFeatureTreeNode.setEditable(false);
        GridData gd_txtSelectedAbstractFeatureTreeNode = new GridData(4, 0x1000000, true, false, 1, 1);
        this.txtSelectedAbstractFeatureTreeNode.setLayoutData((Object)gd_txtSelectedAbstractFeatureTreeNode);
        this.treeViewer = new TreeViewer(top, 68352);
        this.tree = this.treeViewer.getTree();
        GridData gd_tree = new GridData(4, 4, true, true, 2, 1);
        gd_tree.widthHint = 400;
        gd_tree.minimumWidth = 400;
        this.tree.setLayoutData((Object)gd_tree);
        this.tree.setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.adapterFactory));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new CustomAdapterFactoryLabelProvider(this.adapterFactory));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractFeatureNodeSelectionDialog.this.setSelectedAbstractFeatureNode((AbstractFeatureNode)((AbstractFeatureTreeNode)((IStructuredSelection)event.getSelection()).getFirstElement()));
            }
        });
        if (this.featureRootsList != null && !this.featureRootsList.getFeatureRoots().isEmpty()) {
            this.treeViewer.setInput(this.featureRootsList.getFeatureRoots().get(0));
        }
        return top;
    }

    private void setSelectedAbstractFeatureNode(final AbstractFeatureNode newSelectedAbstractFeatureNode) {
        this.selectedAbstractFeatureNode = this.isCompatibleWithFeatureSuperClass((AbstractFeatureSpecifier)newSelectedAbstractFeatureNode) ? newSelectedAbstractFeatureNode : null;
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (AbstractFeatureNodeSelectionDialog.this.txtSelectedAbstractFeatureTreeNode != null && !AbstractFeatureNodeSelectionDialog.this.txtSelectedAbstractFeatureTreeNode.isDisposed()) {
                    if (AbstractFeatureNodeSelectionDialog.this.selectedAbstractFeatureNode != null) {
                        AbstractFeatureNodeSelectionDialog.this.txtSelectedAbstractFeatureTreeNode.setText(ApogyCommonEMFFacade.INSTANCE.getAncestriesString(newSelectedAbstractFeatureNode));
                    } else {
                        AbstractFeatureNodeSelectionDialog.this.txtSelectedAbstractFeatureTreeNode.setText("");
                    }
                }
            }
        });
    }

    private boolean isCompatibleWithFeatureSuperClass(AbstractFeatureSpecifier abstractFeatureSpecifier) {
        if (abstractFeatureSpecifier != null && abstractFeatureSpecifier.getStructuralFeature() != null) {
            EStructuralFeature eStructuralFeature = abstractFeatureSpecifier.getStructuralFeature();
            if (eStructuralFeature instanceof EAttribute) {
                EAttribute eAttribute = (EAttribute)eStructuralFeature;
                Class attributeClass = this.autoBox(eAttribute.getEAttributeType().getInstanceClass());
                return this.featureSuperClass.isAssignableFrom(attributeClass);
            }
            if (eStructuralFeature instanceof EReference) {
                EReference eReference = (EReference)eStructuralFeature;
                Class referrencedClass = eReference.getEType().getInstanceClass();
                return this.featureSuperClass.isAssignableFrom(referrencedClass);
            }
        }
        return false;
    }

    private Class autoBox(Class originalClass) {
        Class autoboxedClass = originalClass;
        if (originalClass.getName() == "boolean") {
            autoboxedClass = Boolean.class;
        } else if (originalClass.getName() == "byte") {
            autoboxedClass = Byte.class;
        } else if (originalClass.getName() == "char") {
            autoboxedClass = Character.class;
        } else if (originalClass.getName() == "float") {
            autoboxedClass = Float.class;
        } else if (originalClass.getName() == "int") {
            autoboxedClass = Integer.class;
        } else if (originalClass.getName() == "long") {
            autoboxedClass = Long.class;
        } else if (originalClass.getName() == "short") {
            autoboxedClass = Short.class;
        } else if (originalClass.getName() == "double") {
            autoboxedClass = Double.class;
        }
        return autoboxedClass;
    }

    private class CustomAdapterFactoryLabelProvider
    extends AdapterFactoryLabelProvider {
        public CustomAdapterFactoryLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Image getImage(Object object) {
            if (AbstractFeatureNodeSelectionDialog.this.featureSuperClass != null && object instanceof AbstractFeatureSpecifier) {
                AbstractFeatureSpecifier abstractFeatureSpecifier = (AbstractFeatureSpecifier)object;
                if (AbstractFeatureNodeSelectionDialog.this.isCompatibleWithFeatureSuperClass(abstractFeatureSpecifier)) {
                    return super.getImage(object);
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
            }
            return super.getImage(object);
        }
    }
}

