/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.ui.birt.composites;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.ui.birt.composites.AbstractBIRTChartComposite;
import org.eclipse.apogy.common.ui.birt.composites.ApogyBIRTUtilities;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.JavaNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.SeriesValueImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

public class XYBIRTChartComposite
extends AbstractBIRTChartComposite {
    public static String DEFAULT_XAXIS_FORMAT_STRING = "0.000";
    public static String DEFAULT_YAXIS_FORMAT_STRING = "0.000";
    protected String xAxisName = null;
    protected String yAxisName = null;
    protected String xAxisFormatString = DEFAULT_XAXIS_FORMAT_STRING;
    protected String yAxisFormatString = DEFAULT_YAXIS_FORMAT_STRING;
    protected List<Couple> currentCouples = new ArrayList<Couple>();
    protected List<Couple> bufferedCouples = new ArrayList<Couple>();
    protected NumberDataSet xValuesDataSet;
    protected NumberDataSet yValuesDataSet;

    public XYBIRTChartComposite(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public void setPlotGridColor(RGB plotGridColor) {
        super.setPlotGridColor(plotGridColor);
        if (plotGridColor != null && this.chart instanceof ChartWithAxes) {
            this.chart.getTitle().getLabel().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(plotGridColor));
            this.xAxis.getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(plotGridColor));
            this.xAxis.getMajorGrid().getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(plotGridColor));
            this.xAxis.getMajorGrid().getTickAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(plotGridColor));
            this.xAxis.getMinorGrid().getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(plotGridColor));
            this.xAxis.getLabel().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(plotGridColor));
            this.yAxis = ((ChartWithAxes)this.chart).getPrimaryOrthogonalAxis(this.xAxis);
            this.yAxis.getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(plotGridColor));
            this.yAxis.getMajorGrid().getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(plotGridColor));
            this.yAxis.getMajorGrid().getTickAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(plotGridColor));
            this.yAxis.getLabel().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(plotGridColor));
        }
    }

    @Override
    public String getXAxisName() {
        return this.xAxisName;
    }

    @Override
    public void setXAxisName(String xAxisName) {
        if (xAxisName != null) {
            this.xAxisName = xAxisName;
            if (this.chart != null && this.xAxis != null) {
                if (xAxisName != null && xAxisName.length() > 0) {
                    this.xAxis.getTitle().setVisible(true);
                    this.xAxis.getTitle().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(this.plotGridColor));
                    this.xAxis.getTitle().getCaption().setValue(xAxisName);
                } else {
                    this.xAxis.getTitle().setVisible(false);
                }
            }
        } else {
            throw new InvalidParameterException("xAxisName cannot be null!");
        }
    }

    @Override
    public String getYAxisName() {
        return this.yAxisName;
    }

    @Override
    public void setYAxisName(String yAxisName) {
        if (yAxisName != null) {
            this.yAxisName = yAxisName;
            if (this.chart != null && this.yAxis != null) {
                if (yAxisName != null && yAxisName.length() > 0) {
                    this.yAxis.getTitle().setVisible(true);
                    this.yAxis.getTitle().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(this.plotGridColor));
                    this.yAxis.getTitle().getCaption().setValue(yAxisName);
                } else {
                    this.yAxis.getTitle().setVisible(false);
                }
            }
        } else {
            throw new InvalidParameterException("yAxisName cannot be null!");
        }
    }

    public String getXAxisFormatString() {
        return this.xAxisFormatString;
    }

    public void setXAxisFormatString(String xAxisFormatString) {
        if (xAxisFormatString != null) {
            this.xAxisFormatString = xAxisFormatString;
            if (this.xAxis != null) {
                JavaNumberFormatSpecifier xAxisFormatSpecifier = JavaNumberFormatSpecifierImpl.create((String)xAxisFormatString);
                this.xAxis.setFormatSpecifier((FormatSpecifier)xAxisFormatSpecifier);
            }
        } else {
            throw new InvalidParameterException("xAxisFormatString cannot be null!");
        }
    }

    public String getYAxisFormatString() {
        return this.yAxisFormatString;
    }

    public void setYAxisFormatString(String yAxisFormatString) {
        if (yAxisFormatString != null) {
            this.yAxisFormatString = yAxisFormatString;
            if (this.yAxis != null) {
                JavaNumberFormatSpecifier yAxisFormatSpecifier = JavaNumberFormatSpecifierImpl.create((String)yAxisFormatString);
                this.yAxis.setFormatSpecifier((FormatSpecifier)yAxisFormatSpecifier);
            }
        } else {
            throw new InvalidParameterException("yAxisFormatString cannot be null!");
        }
    }

    public void updateValues(List<Double> xValues, List<Double> yValues) {
        if (xValues.size() == yValues.size()) {
            this.xValuesDataSet = NumberDataSetImpl.create(xValues);
            this.yValuesDataSet = NumberDataSetImpl.create(yValues);
            this.xSeries.setDataSet((DataSet)this.xValuesDataSet);
            this.ySeries.setDataSet((DataSet)this.yValuesDataSet);
            this.updateChart();
        } else {
            System.err.println("Invalid size");
        }
    }

    @Override
    public void setSeriesColor(RGB seriesColor) {
        super.setSeriesColor(seriesColor);
        if (seriesColor != null) {
            if (this.ySeriesDefinition != null) {
                this.ySeriesDefinition.getSeriesPalette().update((Fill)ApogyBIRTUtilities.convertToColorDefinition(seriesColor));
            }
        } else {
            throw new InvalidParameterException("seriesColor cannot be null!");
        }
    }

    @Override
    protected Chart createChart() {
        ChartWithAxes chart = ChartWithAxesImpl.create();
        chart.getBlock().setBackground((Fill)ColorDefinitionImpl.BLACK());
        chart.getTitle().getLabel().getCaption().setValue(this.chartTitle);
        chart.getTitle().getLabel().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(this.plotGridColor));
        Plot plot = chart.getPlot();
        plot.setBackground((Fill)ColorDefinitionImpl.BLACK());
        plot.getClientArea().setBackground((Fill)ColorDefinitionImpl.BLACK());
        chart.getTitle().getLabel().getCaption().setValue("Click \"Line Series\" to Toggle Visibility");
        chart.setUnitSpacing(20.0);
        Legend lg = chart.getLegend();
        LineAttributes lia = lg.getOutline();
        lg.getText().getFont().setSize(16.0f);
        lia.setStyle(LineStyle.SOLID_LITERAL);
        lg.getInsets().set(10.0, 5.0, 0.0, 0.0);
        lg.getOutline().setVisible(false);
        lg.setAnchor(Anchor.NORTH_LITERAL);
        lg.getTriggers().add((Object)TriggerImpl.create((TriggerCondition)TriggerCondition.ONMOUSEDOWN_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.TOGGLE_VISIBILITY_LITERAL, (ActionValue)SeriesValueImpl.create((String)"not-used"))));
        this.xAxis = chart.getPrimaryBaseAxes()[0];
        this.xAxis.setType(AxisType.LINEAR_LITERAL);
        this.xAxis.setCategoryAxis(false);
        this.xAxis.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        this.xAxis.getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(this.plotGridColor));
        this.xAxis.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        this.xAxis.getMajorGrid().getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(this.plotGridColor));
        this.xAxis.getMajorGrid().getTickAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(this.plotGridColor));
        this.xAxis.getMajorGrid().getLineAttributes().setStyle(LineStyle.DASH_DOTTED_LITERAL);
        this.xAxis.getMajorGrid().getLineAttributes().setVisible(true);
        this.xAxis.getMinorGrid().getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(this.plotGridColor));
        this.xAxis.getMinorGrid().getLineAttributes().setVisible(false);
        this.xAxis.getMinorGrid().getTickAttributes().setVisible(false);
        this.xAxis.getLabel().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(this.plotGridColor));
        JavaNumberFormatSpecifier xAxisFormatSpecifier = JavaNumberFormatSpecifierImpl.create((String)this.xAxisFormatString);
        this.xAxis.setFormatSpecifier((FormatSpecifier)xAxisFormatSpecifier);
        this.yAxis = chart.getPrimaryOrthogonalAxis(this.xAxis);
        this.yAxis.setType(AxisType.LINEAR_LITERAL);
        this.yAxis.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        this.yAxis.getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(this.plotGridColor));
        this.yAxis.getLineAttributes().setVisible(true);
        this.yAxis.getMajorGrid().getLineAttributes().setStyle(LineStyle.DASH_DOTTED_LITERAL);
        this.yAxis.getMajorGrid().getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(this.plotGridColor));
        this.yAxis.getMajorGrid().getLineAttributes().setVisible(true);
        this.yAxis.getMajorGrid().getTickAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(this.plotGridColor));
        this.yAxis.getMinorGrid().getLineAttributes().setVisible(false);
        this.yAxis.getLabel().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(this.plotGridColor));
        JavaNumberFormatSpecifier yAxisFormatSpecifier = JavaNumberFormatSpecifierImpl.create((String)this.yAxisFormatString);
        this.yAxis.setFormatSpecifier((FormatSpecifier)yAxisFormatSpecifier);
        ArrayList<Double> xs = new ArrayList<Double>();
        xs.add(0.0);
        ArrayList<Double> ys = new ArrayList<Double>();
        ys.add(0.0);
        this.xValuesDataSet = NumberDataSetImpl.create(xs);
        this.yValuesDataSet = NumberDataSetImpl.create(ys);
        this.xSeries = SeriesImpl.create();
        this.xSeries.setDataSet((DataSet)this.xValuesDataSet);
        this.ySeries = (LineSeries)LineSeriesImpl.create();
        this.ySeries.setStacked(true);
        this.ySeries.getLabel().setVisible(false);
        this.ySeries.setDataSet((DataSet)this.yValuesDataSet);
        this.ySeries.getLineAttributes().setColor(ColorDefinitionImpl.BLACK());
        int i = 0;
        while (i < this.ySeries.getMarkers().size()) {
            ((Marker)this.ySeries.getMarkers().get(i)).setType(MarkerType.CIRCLE_LITERAL);
            ((Marker)this.ySeries.getMarkers().get(i)).setSize(1);
            ((Marker)this.ySeries.getMarkers().get(i)).setVisible(false);
            ++i;
        }
        this.xSeriesDefinition = SeriesDefinitionImpl.create();
        this.xSeriesDefinition.getSeriesPalette().shift(0);
        this.xAxis.getSeriesDefinitions().add((Object)this.xSeriesDefinition);
        this.ySeriesDefinition = SeriesDefinitionImpl.create();
        this.ySeriesDefinition.getSeriesPalette().update((Fill)ColorDefinitionImpl.YELLOW());
        this.yAxis.getSeriesDefinitions().add((Object)this.ySeriesDefinition);
        this.xSeriesDefinition.getSeries().add((Object)this.xSeries);
        this.ySeriesDefinition.getSeries().add((Object)this.ySeries);
        chart.getLegend().setVisible(false);
        this.setXAxisFormatString(DEFAULT_XAXIS_FORMAT_STRING);
        this.setYAxisFormatString(DEFAULT_YAXIS_FORMAT_STRING);
        return chart;
    }

    @Override
    protected void updateValuesAndChart() {
    }

    @Override
    protected DataSet getXSeriesDataSet() {
        return null;
    }

    @Override
    protected DataSet getYSeriesDataSet() {
        return null;
    }

    protected class Couple {
        public double x;
        public double y;

        public Couple(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

