/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.moon.surface;

import java.util.Date;
import java.util.Iterator;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.math.Matrix3x3;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFactory;
import org.eclipse.apogy.core.environment.Earth;
import org.eclipse.apogy.core.environment.HorizontalCoordinates;
import org.eclipse.apogy.core.environment.Sky;
import org.eclipse.apogy.core.environment.SkyNode;
import org.eclipse.apogy.core.environment.moon.MoonWorksite;
import org.eclipse.apogy.core.environment.moon.SelenographicCoordinates;
import org.eclipse.apogy.core.environment.moon.surface.ApogyMoonSurfaceEnvironmentFacade;
import org.eclipse.apogy.core.environment.moon.surface.MoonSkyNode;
import org.eclipse.apogy.core.environment.moon.surface.MoonSurfaceUtilsCustomImpl;
import org.eclipse.apogy.core.environment.moon.surface.MoonSurfaceWorksite;
import org.eclipse.apogy.core.environment.moon.surface.impl.MoonSkyImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoonSkyCustomImpl
extends MoonSkyImpl {
    private static final Logger Logger = LoggerFactory.getLogger(MoonSkyCustomImpl.class);
    private Adapter adapter = null;

    public MoonSkyCustomImpl() {
        this.eAdapters().add((Object)this.getAdapter());
    }

    public SkyNode getSkyNode() {
        if (this.skyNode == null || !(this.skyNode instanceof MoonSkyNode)) {
            MoonWorksite moonWorksite = (MoonWorksite)this.getWorksite();
            this.skyNode = ApogyMoonSurfaceEnvironmentFacade.INSTANCE.createMoonSkyNode(moonWorksite.getSelenographicCoordinates());
            this.skyNode.setSky((Sky)this);
        }
        return super.getSkyNode();
    }

    @Override
    public HorizontalCoordinates getSunHorizontalCoordinates() {
        if (super.getSunHorizontalCoordinates() == null) {
            HorizontalCoordinates newHorizontalCoordinates = ApogyCoreEnvironmentFactory.eINSTANCE.createHorizontalCoordinates();
            this.setSunHorizontalCoordinates(newHorizontalCoordinates);
        }
        return this.sunHorizontalCoordinates;
    }

    public double getSunAngularDiameter() {
        double angularDiameter = Math.toRadians(0.535833333);
        return angularDiameter;
    }

    @Override
    public Earth getEarth() {
        if (this.basicGetEarth() == null) {
            this.earth = this.findEarthInTopology();
        }
        return this.earth;
    }

    @Override
    public double getEarthAngularDiameter() {
        TransformNode transform = (TransformNode)this.getEarth().getParent();
        Vector3d vector = new Vector3d();
        transform.asMatrix4d().get(vector);
        double distance = vector.length();
        double angularDiameter = Math.atan(this.getEarth().getRadius() / distance) * 2.0;
        return angularDiameter;
    }

    @Override
    public HorizontalCoordinates getEarthHorizontalCoordinates() {
        if (super.getEarthHorizontalCoordinates() == null) {
            HorizontalCoordinates newHorizontalCoordinates = ApogyCoreEnvironmentFactory.eINSTANCE.createHorizontalCoordinates();
            this.setEarthHorizontalCoordinates(newHorizontalCoordinates);
        }
        return this.earthHorizontalCoordinates;
    }

    public void setTime(Date newTime) {
        super.setTime(newTime);
        if (this.getWorksite() != null) {
            if (newTime != null) {
                this.updateSky(newTime.getTime());
            } else {
                this.updateSky(new Date().getTime());
            }
        }
    }

    private Earth findEarthInTopology() {
        Earth foundEarth = null;
        EList children = this.getSkyNode().getChildren();
        Iterator it = children.iterator();
        while (it.hasNext() && foundEarth == null) {
            Node node = (Node)it.next();
            if (!(node instanceof TransformNode)) continue;
            TransformNode t = (TransformNode)node;
            EList tChildren = t.getChildren();
            Iterator tIt = tChildren.iterator();
            while (tIt.hasNext() && foundEarth == null) {
                Node n = (Node)tIt.next();
                if (!(n instanceof Earth)) continue;
                foundEarth = (Earth)n;
            }
        }
        return foundEarth;
    }

    private void updateSky(long newTime) {
        SelenographicCoordinates selenographicCoordinates;
        MoonWorksite worksite = (MoonWorksite)this.getWorksite();
        if (worksite != null && (selenographicCoordinates = worksite.getSelenographicCoordinates()) != null) {
            try {
                Date newDate = new Date(newTime);
                double observerLongitude = selenographicCoordinates.getLongitude();
                double observerLatitude = selenographicCoordinates.getLatitude();
                double observerAltitude = selenographicCoordinates.getElevation();
                HorizontalCoordinates sunHorizontalCoordinates = MoonSurfaceUtilsCustomImpl.INSTANCE.getHorizontalSunPosition(newDate, observerLongitude, observerLatitude, observerAltitude);
                this.setSunHorizontalCoordinates(sunHorizontalCoordinates);
                HorizontalCoordinates moonHorizontalCoordinates = MoonSurfaceUtilsCustomImpl.INSTANCE.getHorizontalEarthPosition(newDate, observerLongitude, observerLatitude, observerAltitude);
                this.setEarthHorizontalCoordinates(moonHorizontalCoordinates);
                Matrix3x3 earthRotation = MoonSurfaceUtilsCustomImpl.INSTANCE.getEarthOrientation(newDate, observerLongitude, observerLatitude, observerAltitude);
                this.setEarthOrientation(earthRotation);
            }
            catch (Exception e) {
                Logger.error("Error occured during Sky Update !", (Throwable)e);
            }
        }
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void notifyChanged(Notification msg) {
                    try {
                        if (msg.getNotifier() instanceof MoonSkyCustomImpl) {
                            int featureId = msg.getFeatureID(MoonSkyCustomImpl.class);
                            switch (featureId) {
                                case 1: {
                                    if (msg.getOldValue() instanceof MoonSurfaceWorksite) {
                                        MoonSurfaceWorksite oldWorksite = (MoonSurfaceWorksite)msg.getOldValue();
                                        oldWorksite.eAdapters().remove((Object)MoonSkyCustomImpl.this.getAdapter());
                                        if (oldWorksite.getSelenographicCoordinates() != null) {
                                            oldWorksite.getSelenographicCoordinates().eAdapters().remove((Object)MoonSkyCustomImpl.this.getAdapter());
                                        }
                                    }
                                    if (!(msg.getNewValue() instanceof MoonSurfaceWorksite)) return;
                                    MoonSurfaceWorksite newWorksite = (MoonSurfaceWorksite)msg.getNewValue();
                                    newWorksite.eAdapters().add((Object)MoonSkyCustomImpl.this.getAdapter());
                                    if (newWorksite.getSelenographicCoordinates() == null) return;
                                    newWorksite.getSelenographicCoordinates().eAdapters().add((Object)MoonSkyCustomImpl.this.getAdapter());
                                    long time = new Date().getTime();
                                    if (MoonSkyCustomImpl.this.getTime() != null) {
                                        time = MoonSkyCustomImpl.this.getTime().getTime() + 1L;
                                    }
                                    MoonSkyCustomImpl.this.updateSky(time);
                                    return;
                                }
                                default: {
                                    return;
                                }
                            }
                        } else if (msg.getNotifier() instanceof MoonSurfaceWorksite) {
                            int featureId = msg.getFeatureID(MoonSurfaceWorksite.class);
                            switch (featureId) {
                                case 7: {
                                    if (msg.getOldValue() instanceof SelenographicCoordinates) {
                                        SelenographicCoordinates oldCoordinates = (SelenographicCoordinates)msg.getOldValue();
                                        oldCoordinates.eAdapters().remove((Object)MoonSkyCustomImpl.this.getAdapter());
                                    }
                                    if (!(msg.getNewValue() instanceof SelenographicCoordinates)) return;
                                    SelenographicCoordinates newCoordinates = (SelenographicCoordinates)msg.getNewValue();
                                    newCoordinates.eAdapters().add((Object)MoonSkyCustomImpl.this.getAdapter());
                                    long time = new Date().getTime();
                                    if (MoonSkyCustomImpl.this.getTime() != null) {
                                        time = MoonSkyCustomImpl.this.getTime().getTime() + 1L;
                                    }
                                    MoonSkyCustomImpl.this.updateSky(time);
                                }
                                default: {
                                    return;
                                }
                            }
                        } else {
                            if (!(msg.getNotifier() instanceof SelenographicCoordinates)) return;
                            long time = new Date().getTime();
                            if (MoonSkyCustomImpl.this.getTime() != null) {
                                time = MoonSkyCustomImpl.this.getTime().getTime() + 1L;
                            }
                            MoonSkyCustomImpl.this.updateSky(time);
                        }
                        return;
                    }
                    catch (Throwable t) {
                        Logger.error("Error occured during worksite coordinates update !", t);
                    }
                }
            };
        }
        return this.adapter;
    }
}

