/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.moon.surface;

import java.util.Date;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFacade;
import org.eclipse.apogy.core.environment.Earth;
import org.eclipse.apogy.core.environment.HorizontalCoordinates;
import org.eclipse.apogy.core.environment.Sky;
import org.eclipse.apogy.core.environment.StarField;
import org.eclipse.apogy.core.environment.Sun;
import org.eclipse.apogy.core.environment.moon.MoonWorksite;
import org.eclipse.apogy.core.environment.moon.surface.MoonSky;
import org.eclipse.apogy.core.environment.moon.surface.impl.MoonSkyNodeImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;

public class MoonSkyNodeCustomImpl
extends MoonSkyNodeImpl {
    private Adapter moonSkyAdapter = null;

    public void setSky(Sky newSky) {
        if (this.getSky() != null) {
            this.getSky().eAdapters().remove((Object)this.getMoonSkyAdapter());
        }
        if (newSky != null) {
            newSky.eAdapters().add((Object)this.getMoonSkyAdapter());
        }
        super.setSky(newSky);
    }

    protected Adapter getMoonSkyAdapter() {
        if (this.moonSkyAdapter == null) {
            this.moonSkyAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof MoonSky) {
                        Date newTime;
                        MoonSky earthSky = (MoonSky)msg.getNotifier();
                        if (msg.getFeatureID(MoonSky.class) == 5) {
                            HorizontalCoordinates sunHorizontalCoordinates = (HorizontalCoordinates)msg.getNewValue();
                            Sun sun = earthSky.getSun();
                            Point3d sunPosition = ApogyCoreEnvironmentFacade.INSTANCE.convertFromHorizontalCoordinatesToHorizontalRectangular(sunHorizontalCoordinates);
                            if (sun != null) {
                                TransformNode sunTransformNode = (TransformNode)sun.getParent();
                                sunTransformNode.setPosition(ApogyCommonMathFacade.INSTANCE.createTuple3d((Tuple3d)sunPosition));
                            }
                        } else if (msg.getFeatureID(MoonSky.class) == 7) {
                            HorizontalCoordinates moonHorizontalCoordinates = (HorizontalCoordinates)msg.getNewValue();
                            Earth earth = earthSky.getEarth();
                            Point3d earthPosition = ApogyCoreEnvironmentFacade.INSTANCE.convertFromHorizontalCoordinatesToHorizontalRectangular(moonHorizontalCoordinates);
                            if (earth != null) {
                                TransformNode earthTransformNode = (TransformNode)earth.getParent();
                                earthTransformNode.setPosition(ApogyCommonMathFacade.INSTANCE.createTuple3d((Tuple3d)earthPosition));
                            }
                        } else if (msg.getFeatureID(MoonSky.class) == 0 && (newTime = (Date)msg.getNewValue()) != null) {
                            StarField starField = earthSky.getStarField();
                            MoonWorksite worksite = (MoonWorksite)earthSky.getWorksite();
                            Matrix3d m = MoonSkyNodeCustomImpl.this.updateStarsRotationMatrix(worksite, newTime.getTime());
                            if (starField != null) {
                                TransformNode starFieldTransformNode = (TransformNode)starField.getParent();
                                starFieldTransformNode.setRotationMatrix(ApogyCommonMathFacade.INSTANCE.createMatrix3x3(m));
                            }
                        }
                    }
                }
            };
        }
        return this.moonSkyAdapter;
    }

    private Matrix3d updateStarsRotationMatrix(MoonWorksite worksite, long newTime) {
        Matrix3d m = new Matrix3d();
        m.setIdentity();
        return m;
    }
}

