/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.ui.impl;

import org.eclipse.apogy.addons.sensors.imaging.ui.Activator;
import org.eclipse.apogy.addons.sensors.imaging.ui.ImageSnapshotSceneObject;
import org.eclipse.apogy.addons.sensors.imaging.ui.impl.ImageSnapshotPresentationImpl;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;

public class ImageSnapshotPresentationCustomImpl
extends ImageSnapshotPresentationImpl {
    protected IPropertyChangeListener preferencesListener = null;
    protected static final MeshPresentationMode PRESENTATION_MODE_EDEFAULT = MeshPresentationMode.WIREFRAME;

    protected ImageSnapshotPresentationCustomImpl() {
        this.applyPreferences();
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.getPreferencesListener());
    }

    protected void initialSceneObject() {
        ImageSnapshotSceneObject imageSnapshotSceneObject = (ImageSnapshotSceneObject)this.getSceneObject();
        imageSnapshotSceneObject.setTransparency(this.transparency);
        imageSnapshotSceneObject.setPresentationMode(this.getPresentationMode());
        imageSnapshotSceneObject.setImageProjectionEnabled(this.imageProjectionVisible);
        imageSnapshotSceneObject.setImageProjectionOnFOVEnabled(this.isImageProjectionOnFOVVisible());
        imageSnapshotSceneObject.setFOVVisible(this.isFovVisible());
        imageSnapshotSceneObject.setAxisVisible(this.isAxisVisible());
        imageSnapshotSceneObject.setAxisLength(this.getAxisLength());
        super.initialSceneObject();
    }

    protected void updateSceneObject(Notification notification) {
        ImageSnapshotSceneObject imageSnapshotSceneObject = (ImageSnapshotSceneObject)this.getSceneObject();
        if (notification.getNotifier() instanceof ImageSnapshotPresentationCustomImpl) {
            int featureId = notification.getFeatureID(ImageSnapshotPresentationCustomImpl.class);
            switch (featureId) {
                case 17: {
                    imageSnapshotSceneObject.setPresentationMode(this.getPresentationMode());
                    break;
                }
                case 18: {
                    imageSnapshotSceneObject.setTransparency(this.getTransparency());
                    break;
                }
                case 20: {
                    imageSnapshotSceneObject.setImageProjectionEnabled(this.isImageProjectionVisible());
                    break;
                }
                case 21: {
                    imageSnapshotSceneObject.setImageProjectionOnFOVEnabled(this.isImageProjectionOnFOVVisible());
                    break;
                }
                case 19: {
                    imageSnapshotSceneObject.setFOVVisible(this.isFovVisible());
                    break;
                }
                case 22: {
                    imageSnapshotSceneObject.setAxisVisible(this.isAxisVisible());
                    break;
                }
                case 23: {
                    imageSnapshotSceneObject.setAxisLength(this.getAxisLength());
                    break;
                }
            }
        }
        super.updateSceneObject(notification);
    }

    protected void applyPreferences() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"DEFAULT_IMAGE_SNAPSHOT_FOV_COLOR_ID");
        if (rgb != null) {
            this.setColor(ApogyCommonEMFUIFacade.INSTANCE.convertToRGBA(rgb));
        }
        this.setVisible(store.getBoolean("DEFAULT_IMAGE_SNAPSHOT_VISIBILITY_ID"));
        this.setFovVisible(store.getBoolean("DEFAULT_IMAGE_SNAPSHOT_FOV_VISIBLE_ID"));
        this.setImageProjectionVisible(store.getBoolean("DEFAULT_IMAGE_SNAPSHOT_SHOW_PROJECTION_ID"));
        this.setImageProjectionOnFOVVisible(store.getBoolean("DEFAULT_IMAGE_SNAPSHOT_SHOW_PROJECTION_ON_FOV_ID"));
        this.setPresentationMode(MeshPresentationMode.get((int)store.getInt("DEFAULT_IMAGE_SNAPSHOT_FOV_PRESENTATION_MODE_ID")));
        this.setAxisVisible(store.getBoolean("DEFAULT_IMAGE_SNAPSHOT_AXIS_VISIBLE_ID"));
        this.setAxisLength(store.getDouble("DEFAULT_IMAGE_SNAPSHOT_AXIS_LENGTH_ID"));
        super.applyPreferences();
    }

    private IPropertyChangeListener getPreferencesListener() {
        if (this.preferencesListener == null) {
            this.preferencesListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    ImageSnapshotPresentationCustomImpl.this.applyPreferences();
                }
            };
        }
        return this.preferencesListener;
    }
}

