/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.planner;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EclipsePeriod implements Enumerator
{
    NOT_IN_ECLIPSE(0, "NotInEclipse", "NOT_IN_ECLIPSE"),
    PENUMBRA(1, "Penumbra", "PENUMBRA"),
    UMBRA(2, "Umbra", "UMBRA");

    public static final int NOT_IN_ECLIPSE_VALUE = 0;
    public static final int PENUMBRA_VALUE = 1;
    public static final int UMBRA_VALUE = 2;
    private static final EclipsePeriod[] VALUES_ARRAY;
    public static final List<EclipsePeriod> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EclipsePeriod[]{NOT_IN_ECLIPSE, PENUMBRA, UMBRA};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EclipsePeriod get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EclipsePeriod result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EclipsePeriod getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EclipsePeriod result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EclipsePeriod get(int value) {
        switch (value) {
            case 0: {
                return NOT_IN_ECLIPSE;
            }
            case 1: {
                return PENUMBRA;
            }
            case 2: {
                return UMBRA;
            }
        }
        return null;
    }

    private EclipsePeriod(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

