/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.planner.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.EObjectReferencesList;
import org.eclipse.apogy.common.emf.TimeInterval;
import org.eclipse.apogy.core.environment.earth.orbit.ApogyCoreEnvironmentEarthOrbitFacade;
import org.eclipse.apogy.core.environment.earth.orbit.EarthOrbitTool;
import org.eclipse.apogy.core.environment.earth.orbit.EarthOrbitTools;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPass;
import org.eclipse.apogy.core.environment.earth.orbit.planner.AbstractCostFunction;
import org.eclipse.apogy.core.environment.earth.orbit.planner.AbstractStatefulCostFunction;
import org.eclipse.apogy.core.environment.earth.orbit.planner.AbstractStatelessCostFunction;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ApogyCoreEnvironmentEarthOrbitPlannerFactory;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ApogyCoreEnvironmentEarthOrbitPlannerPackage;
import org.eclipse.apogy.core.environment.earth.orbit.planner.CostFunctionState;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ObservationAnalysisPlanner;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ObservationAnalysisPlannerNode;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ObservationAnalysisPlannerResult;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ObservationAnalysisPlannerTool;
import org.eclipse.apogy.core.environment.earth.orbit.planner.StatefulCostFunctionMapEntryValue;
import org.eclipse.apogy.core.environment.earth.orbit.planner.StatelessCostFunctionMap;
import org.eclipse.apogy.core.environment.earth.orbit.planner.impl.ApogyCoreEnvironmentEarthOrbitPlannerFacadeImpl;
import org.eclipse.apogy.core.environment.earth.orbit.planner.impl.StatefulCostFunctionMapEntryImpl;
import org.eclipse.apogy.core.environment.earth.orbit.planner.impl.StatelessCostsMapEntryImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyCoreEnvironmentEarthOrbitPlannerFacadeCustomImpl
extends ApogyCoreEnvironmentEarthOrbitPlannerFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyCoreEnvironmentEarthOrbitPlannerFacadeCustomImpl.class);

    @Override
    public ObservationAnalysisPlannerNode generateObservationsPlanTree(List<VisibilityPass> passes, IProgressMonitor monitor) {
        Logger.info("Generate Observations Plan Tree started.");
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)passes.size());
        List<VisibilityPass> sortedPasses = passes.stream().sorted(Comparator.comparing(TimeInterval::getFromDate)).collect(Collectors.toList());
        ObservationAnalysisPlannerNode rootNode = ApogyCoreEnvironmentEarthOrbitPlannerFactory.eINSTANCE.createObservationAnalysisPlannerNode();
        this.generateObservationAnalysisPlannerNode(rootNode, sortedPasses, subMonitor);
        Logger.info("Generate Observations Plan Tree completed.");
        return rootNode;
    }

    protected void generateObservationAnalysisPlannerNode(ObservationAnalysisPlannerNode parent, List<VisibilityPass> passes, SubMonitor monitor) {
        int childId = 1;
        for (VisibilityPass pass : passes) {
            if (parent.getPass() != null && !parent.getPass().getFromDate().before(pass.getFromDate())) continue;
            ObservationAnalysisPlannerNode childNode = ApogyCoreEnvironmentEarthOrbitPlannerFactory.eINSTANCE.createObservationAnalysisPlannerNode();
            childNode.setId(parent.getId() == null ? "" + childId : (parent.getId().isEmpty() ? "" + childId : String.valueOf(parent.getId()) + "." + childId));
            List<VisibilityPass> reducedVisibilityPasses = passes.stream().filter(p -> p != pass && p.getOutlook() != pass.getOutlook()).collect(Collectors.toList());
            childNode.setPass(pass);
            parent.getChildren().add((Object)childNode);
            SubMonitor subMonitor = monitor.split(reducedVisibilityPasses.size());
            this.generateObservationAnalysisPlannerNode(childNode, reducedVisibilityPasses, subMonitor);
            ++childId;
        }
    }

    @Override
    public ObservationAnalysisPlanner computePlanCosts(ObservationAnalysisPlanner planner, IProgressMonitor monitor) {
        Logger.info("Computing Observations Plan Costs started.");
        this.initialiseCostFunctions(planner);
        ApogyCommonTransactionFacade.INSTANCE.basicClear((EObject)planner.getResult(), (EStructuralFeature)ApogyCoreEnvironmentEarthOrbitPlannerPackage.Literals.OBSERVATION_ANALYSIS_PLANNER_RESULT__STATELESS_COSTS_MAP_ENTRIES);
        for (VisibilityPass visibilityPass : planner.getOrbitAnalysisData().getResult().getObservationTargetVisibilityPasses()) {
            StatelessCostsMapEntryImpl statelessCostsMapEntry = new StatelessCostsMapEntryImpl();
            statelessCostsMapEntry.setKey(visibilityPass);
            statelessCostsMapEntry.setValue(ApogyCoreEnvironmentEarthOrbitPlannerFactory.eINSTANCE.createStatelessCostFunctionMap());
            for (AbstractStatelessCostFunction costFunction : planner.getStatelessCostFunctions()) {
                if (!this.isCostFunctionApplicable(costFunction, visibilityPass)) continue;
                double cost = Double.POSITIVE_INFINITY;
                try {
                    cost = costFunction.getCoefficient() * costFunction.computeCost(visibilityPass);
                }
                catch (Throwable throwable) {
                    cost = Double.POSITIVE_INFINITY;
                    Logger.error("Problem to process cost function <" + costFunction.getName() + "> for target <" + visibilityPass.getOutlook().getName() + "> with spacecraft <" + visibilityPass.getSpacecraft().getName() + ">. An infinite cost value is set.");
                }
                statelessCostsMapEntry.getValue().getStatelessCostFunctionMapEntries().put((Object)costFunction, (Object)cost);
            }
            AddCommand command = (AddCommand)AddCommand.create((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain(), (Object)planner.getResult(), (Object)ApogyCoreEnvironmentEarthOrbitPlannerPackage.Literals.OBSERVATION_ANALYSIS_PLANNER_RESULT__STATELESS_COSTS_MAP_ENTRIES, (Object)((Object)statelessCostsMapEntry));
            ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain().getCommandStack().execute((Command)command);
        }
        this.computeStatefulCosts(planner, planner.getResult().getPlanRootNode(), monitor);
        Logger.info("Computing Observations Plan Costs completed.");
        return planner;
    }

    protected void initialiseCostFunctions(ObservationAnalysisPlanner planner) {
        for (AbstractCostFunction costFunction : planner.getStatelessCostFunctions()) {
            try {
                costFunction.initialize(planner.getOrbitAnalysisData());
            }
            catch (Exception e) {
                Logger.error("Stateless Cost function <" + costFunction.getName() + "> failed to initialize.", (Throwable)e);
            }
        }
        for (AbstractCostFunction costFunction : planner.getStatefulCostFunctions()) {
            try {
                costFunction.initialize(planner.getOrbitAnalysisData());
            }
            catch (Exception e) {
                Logger.error("StateFul Cost function <" + costFunction.getName() + "> failed to initialize.", (Throwable)e);
            }
        }
    }

    protected void computeStatefulCosts(ObservationAnalysisPlanner planner, ObservationAnalysisPlannerNode node, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)node.getChildren().size());
        for (ObservationAnalysisPlannerNode child : node.getChildren()) {
            for (AbstractStatefulCostFunction costFunction : planner.getStatefulCostFunctions()) {
                if (!this.isCostFunctionApplicable(costFunction, child.getPass())) continue;
                try {
                    CostFunctionState previousState = null;
                    if (!node.isRootNode()) {
                        StatefulCostFunctionMapEntryValue statefulCostFunctionMapEntryValue = (StatefulCostFunctionMapEntryValue)node.getStatefulCostsMapEntries().get((Object)costFunction);
                        previousState = statefulCostFunctionMapEntryValue != null ? statefulCostFunctionMapEntryValue.getState() : null;
                    }
                    CostFunctionState nextState = costFunction.createState();
                    double cost = costFunction.getCoefficient() * costFunction.computeCost(previousState, nextState, child.getPass());
                    StatefulCostFunctionMapEntryValue statefulCostFunctionMapEntryValue = ApogyCoreEnvironmentEarthOrbitPlannerFactory.eINSTANCE.createStatefulCostFunctionMapEntryValue();
                    statefulCostFunctionMapEntryValue.setCost(cost);
                    statefulCostFunctionMapEntryValue.setState(nextState);
                    StatefulCostFunctionMapEntryImpl statefulCostFunctionMapEntryImpl = new StatefulCostFunctionMapEntryImpl();
                    statefulCostFunctionMapEntryImpl.setKey(costFunction);
                    statefulCostFunctionMapEntryImpl.setValue(statefulCostFunctionMapEntryValue);
                    AddCommand command = (AddCommand)AddCommand.create((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain(), (Object)child, (Object)ApogyCoreEnvironmentEarthOrbitPlannerPackage.Literals.OBSERVATION_ANALYSIS_PLANNER_NODE__STATEFUL_COSTS_MAP_ENTRIES, (Object)((Object)statefulCostFunctionMapEntryImpl));
                    ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain().getCommandStack().execute((Command)command);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Logger.error("Problem to process cost function <" + costFunction.getName() + "> for target <" + child.getPass().getOutlook().getName() + "> with spacecraft <" + child.getPass().getSpacecraft().getName() + ">. An infinite cost value is set.");
                }
            }
            this.computeStatefulCosts(planner, child, (IProgressMonitor)subMonitor);
        }
    }

    @Override
    public ObservationAnalysisPlannerTool getObservationAnalysisPlannerTool() {
        EarthOrbitTools earthOrbitTools = ApogyCoreEnvironmentEarthOrbitFacade.INSTANCE.getActiveEarthOrbitTools();
        ObservationAnalysisPlannerTool tool = null;
        if (earthOrbitTools != null) {
            Iterator it = earthOrbitTools.getTools().iterator();
            while (it.hasNext() && tool == null) {
                EarthOrbitTool earthOrbitTool = (EarthOrbitTool)it.next();
                if (!(earthOrbitTool instanceof ObservationAnalysisPlannerTool)) continue;
                tool = (ObservationAnalysisPlannerTool)earthOrbitTool;
            }
        }
        return tool;
    }

    @Override
    public List<ObservationAnalysisPlannerNode> getLeafs(ObservationAnalysisPlannerNode root) {
        ArrayList<ObservationAnalysisPlannerNode> nodesList = new ArrayList<ObservationAnalysisPlannerNode>();
        for (ObservationAnalysisPlannerNode childNode : root.getChildren()) {
            if (childNode.getChildren().isEmpty()) {
                nodesList.add(childNode);
                continue;
            }
            nodesList.addAll(this.getLeafs(childNode));
        }
        return nodesList;
    }

    @Override
    public EObjectReferencesList<ObservationAnalysisPlannerNode> getPlannerSolution(ObservationAnalysisPlannerNode leaf) {
        EObjectReferencesList solution = ApogyCommonEMFFactory.eINSTANCE.createEObjectReferencesList();
        ObservationAnalysisPlannerNode currentNode = leaf;
        while (currentNode != null && currentNode.getParent() != null && currentNode.getParent() instanceof ObservationAnalysisPlannerNode) {
            solution.getEObjects().add(0, (Object)currentNode);
            currentNode = currentNode.getParent();
        }
        return solution;
    }

    @Override
    public EObjectReferencesList<VisibilityPass> getVisibilityPasses(List<ObservationAnalysisPlannerNode> nodesList) {
        EObjectReferencesList passes = null;
        if (nodesList != null) {
            passes = ApogyCommonEMFFactory.eINSTANCE.createEObjectReferencesList();
            for (ObservationAnalysisPlannerNode node : nodesList) {
                passes.getEObjects().add((Object)node.getPass());
            }
        }
        return passes;
    }

    @Override
    public double getNodeStatelessTotalCost(ObservationAnalysisPlannerNode plannerNode) {
        StatelessCostFunctionMap map;
        double cost = 0.0;
        ObservationAnalysisPlannerResult result = plannerNode.getPlannerResult();
        if (result != null && (map = (StatelessCostFunctionMap)result.getStatelessCostsMapEntries().get((Object)plannerNode.getPass())) != null) {
            for (Double value : map.getStatelessCostFunctionMapEntries().values()) {
                cost += value.doubleValue();
            }
        }
        return cost;
    }

    @Override
    public double getNodeStatefulTotalCost(ObservationAnalysisPlannerNode plannerNode) {
        double cost = 0.0;
        for (StatefulCostFunctionMapEntryValue value : plannerNode.getStatefulCostsMapEntries().values()) {
            cost += value.getCost();
        }
        return cost;
    }

    @Override
    public double getNodeTotalCost(ObservationAnalysisPlannerNode plannerNode) {
        return this.getNodeStatelessTotalCost(plannerNode) + this.getNodeStatefulTotalCost(plannerNode);
    }

    @Override
    public double getSolutionTotalCost(EObjectReferencesList<ObservationAnalysisPlannerNode> plan) {
        double cost = 0.0;
        for (ObservationAnalysisPlannerNode node : plan.getEObjects()) {
            cost += this.getNodeTotalCost(node);
        }
        return cost;
    }

    @Override
    public boolean isCostFunctionApplicable(AbstractCostFunction abstractCostFunction, VisibilityPass visibilityPass) {
        if (!abstractCostFunction.isEnable()) {
            return false;
        }
        if (abstractCostFunction.getCoefficient() == 0.0) {
            return false;
        }
        if (!abstractCostFunction.getApplicableSpacecrafts().isEmpty() && !abstractCostFunction.getApplicableSpacecrafts().contains((Object)visibilityPass.getSpacecraft())) {
            return false;
        }
        return abstractCostFunction.getApplicableEarthOutlooks().isEmpty() || abstractCostFunction.getApplicableEarthOutlooks().contains((Object)visibilityPass.getOutlook());
    }
}

