/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.planner.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.EObjectReferencesList;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ObservationAnalysisPlanner;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ObservationAnalysisPlannerNode;
import org.eclipse.apogy.core.environment.earth.orbit.planner.impl.DefaultObservationPlanExporterImpl;
import org.eclipse.core.runtime.IProgressMonitor;

public class DefaultObservationPlanExporterCustomImpl
extends DefaultObservationPlanExporterImpl {
    @Override
    public void exportObservationPlan(EObjectReferencesList<ObservationAnalysisPlannerNode> plan, ObservationAnalysisPlanner planner, IProgressMonitor monitor) throws Exception {
        URL url = new URL(this.getFileURL());
        File file = new File(url.toURI());
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        String header = String.valueOf(this.createHeader()) + "\n";
        writer.append(header);
        for (ObservationAnalysisPlannerNode plannerNode : plan.getEObjects()) {
            String csvString = String.valueOf(this.createCSVLine(plannerNode)) + "\n";
            writer.append(csvString);
        }
        writer.flush();
        writer.close();
    }

    protected String createHeader() {
        String header = new String();
        header = String.valueOf(header) + "ID,";
        header = String.valueOf(header) + "Spacecraft,";
        header = String.valueOf(header) + "Observation Target,";
        header = String.valueOf(header) + "Start Time,";
        header = String.valueOf(header) + "End Time,";
        header = String.valueOf(header) + "Cost";
        return header;
    }

    protected String createCSVLine(ObservationAnalysisPlannerNode observationAnalysisPlannerNode) {
        String csvLine = new String();
        csvLine = String.valueOf(csvLine) + observationAnalysisPlannerNode.getId() + ",";
        csvLine = String.valueOf(csvLine) + observationAnalysisPlannerNode.getPass().getSpacecraft().getName() + ",";
        csvLine = String.valueOf(csvLine) + observationAnalysisPlannerNode.getPass().getOutlook().getName() + ",";
        csvLine = String.valueOf(csvLine) + ApogyCommonEMFFacade.INSTANCE.format(observationAnalysisPlannerNode.getPass().getFromDate()) + ",";
        csvLine = String.valueOf(csvLine) + ApogyCommonEMFFacade.INSTANCE.format(observationAnalysisPlannerNode.getPass().getToDate()) + ",";
        csvLine = String.valueOf(csvLine) + observationAnalysisPlannerNode.getCost();
        return csvLine;
    }
}

