/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.bindings.impl;

import java.util.Map;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.AbstractFeatureSpecifier;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.PositionNode;
import org.eclipse.apogy.common.topology.bindings.AbstractTopologyBinding;
import org.eclipse.apogy.common.topology.bindings.TranslationBinding;
import org.eclipse.apogy.common.topology.bindings.impl.TranslationBindingImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationBindingCustomImpl
extends TranslationBindingImpl {
    private static final Logger Logger = LoggerFactory.getLogger(TranslationBindingImpl.class);
    private static Unit<?> METERS = Unit.valueOf((CharSequence)"m");
    private double featureToMetersConversionFactor = 1.0;

    @Override
    public AbstractTopologyBinding clone(Map<Node, Node> originalToCopyNodeMap) {
        TranslationBinding translationCopy = (TranslationBinding)EcoreUtil.copy((EObject)this);
        translationCopy.setPositionNode((PositionNode)originalToCopyNodeMap.get(this.getPositionNode()));
        return translationCopy;
    }

    @Override
    public void bind() {
        this.featureToMetersConversionFactor = this.determineConversionFactor();
        super.bind();
    }

    @Override
    public Class<?> getSupportedFeatureType() {
        return Number.class;
    }

    @Override
    protected void valueChanged(Object newValue) {
        double value = 0.0;
        if (newValue instanceof Double) {
            value = (Double)newValue;
        } else if (newValue instanceof Float) {
            value = ((Float)newValue).doubleValue();
        }
        this.applyValue(value *= this.featureToMetersConversionFactor);
    }

    private double determineConversionFactor() {
        double factor = 1.0;
        if (this.getFeatureNode() instanceof AbstractFeatureSpecifier) {
            AbstractFeatureSpecifier featureSpecifier = (AbstractFeatureSpecifier)this.getFeatureNode();
            Unit units = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)featureSpecifier.getStructuralFeature());
            if (units != null) {
                try {
                    factor = units.getConverterTo(METERS).convert(1.0);
                }
                catch (Exception e) {
                    Logger.error("Engineering units of the feature <" + units.toString() + "> are not an lenght value !", (Throwable)e);
                }
            } else {
                Logger.warn("No Engineering units defined for feature, assuming meters.");
            }
        }
        return factor;
    }

    private void applyValue(double newValue) {
        switch (this.getTranslationAxis().getValue()) {
            case 0: {
                double x = newValue;
                double y = this.getPositionNode().getPosition().getY();
                double z = this.getPositionNode().getPosition().getZ();
                this.getPositionNode().setPosition(ApogyCommonMathFacade.INSTANCE.createTuple3d(x, y, z));
                break;
            }
            case 3: {
                double x = -newValue;
                double y = this.getPositionNode().getPosition().getY();
                double z = this.getPositionNode().getPosition().getZ();
                this.getPositionNode().setPosition(ApogyCommonMathFacade.INSTANCE.createTuple3d(x, y, z));
                break;
            }
            case 1: {
                double x = this.getPositionNode().getPosition().getX();
                double y = newValue;
                double z = this.getPositionNode().getPosition().getZ();
                this.getPositionNode().setPosition(ApogyCommonMathFacade.INSTANCE.createTuple3d(x, y, z));
                break;
            }
            case 4: {
                double x = this.getPositionNode().getPosition().getX();
                double y = -newValue;
                double z = this.getPositionNode().getPosition().getZ();
                this.getPositionNode().setPosition(ApogyCommonMathFacade.INSTANCE.createTuple3d(x, y, z));
                break;
            }
            case 2: {
                double x = this.getPositionNode().getPosition().getX();
                double y = this.getPositionNode().getPosition().getY();
                double z = newValue;
                this.getPositionNode().setPosition(ApogyCommonMathFacade.INSTANCE.createTuple3d(x, y, z));
                break;
            }
            case 5: {
                double x = this.getPositionNode().getPosition().getX();
                double y = this.getPositionNode().getPosition().getY();
                double z = -newValue;
                this.getPositionNode().setPosition(ApogyCommonMathFacade.INSTANCE.createTuple3d(x, y, z));
            }
        }
    }
}

