/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.fov.ui.impl;

import javax.vecmath.Point3d;
import org.eclipse.apogy.addons.sensors.fov.ui.Activator;
import org.eclipse.apogy.addons.sensors.fov.ui.impl.CircularSectorFieldOfViewPresentationImpl;
import org.eclipse.apogy.addons.sensors.fov.ui.scene_objects.CircularSectorFieldOfViewSceneObject;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;

public class CircularSectorFieldOfViewPresentationCustomImpl
extends CircularSectorFieldOfViewPresentationImpl {
    protected CircularSectorFieldOfViewPresentationCustomImpl() {
        this.applyPreferences();
    }

    public Tuple3d basicGetCentroid() {
        Point3d point3d = new Point3d();
        if (this.getSceneObject() != null) {
            point3d = this.getSceneObject().getCentroid();
        }
        return ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)point3d);
    }

    @Override
    public void setPresentationMode(MeshPresentationMode newPresentationMode) {
        super.setPresentationMode(newPresentationMode);
        if (this.getSceneObject() instanceof CircularSectorFieldOfViewSceneObject) {
            CircularSectorFieldOfViewSceneObject j3dObject = (CircularSectorFieldOfViewSceneObject)this.getSceneObject();
            j3dObject.setPresentationMode(newPresentationMode);
        }
    }

    @Override
    protected void initialSceneObject() {
        super.initialSceneObject();
    }

    public double getZRange() {
        return 0.0;
    }

    @Override
    protected void applyPreferences() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.setVisible(store.getBoolean("DEFAULT_CIRCULAR_SECTOR_VISIBILITY_ID"));
        this.setFovVisible(store.getBoolean("DEFAULT_CIRCULAR_SECTOR_FOV_VISIBILITY_ID"));
        this.setAxisVisible(store.getBoolean("DEFAULT_CIRCULAR_SECTOR_FOV_AXIS_VISIBLE_ID"));
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"DEFAULT_CIRCULAR_SECTOR_FOV_COLOR");
        if (rgb != null) {
            this.setColor(ApogyCommonEMFUIFacade.INSTANCE.convertToRGBA(rgb));
        }
        this.setShowOutlineOnly(store.getBoolean("DEFAULT_CIRCULAR_SECTOR_FOV_SHOW_OUTLINE_ONLY"));
        this.setShowProjection(store.getBoolean("DEFAULT_CIRCULAR_SECTOR_FOV_SHOW_PROJECTION_ID"));
        RGB projectionColorPref = PreferenceConverter.getColor((IPreferenceStore)store, (String)"DEFAULT_CIRCULAR_SECTOR_FOV_PROJECTION_COLOR_ID");
        if (projectionColorPref != null) {
            this.setProjectionColor(ApogyCommonEMFUIFacade.INSTANCE.convertToRGBA(projectionColorPref));
        }
        this.setPresentationMode(MeshPresentationMode.get((int)store.getInt("DEFAULT_CIRCULAR_SECTOR_FOV_PRESENTATION_MODE")));
        super.applyPreferences();
    }
}

